/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.catalog.schemaApi.builder;

import io.evitadb.api.requestResponse.schema.AttributeSchemaContract;
import io.evitadb.api.requestResponse.schema.CatalogSchemaContract;
import io.evitadb.api.requestResponse.schema.EntitySchemaContract;
import io.evitadb.api.requestResponse.schema.NamedSchemaContract;
import io.evitadb.externalApi.api.ExternalApiNamingConventions;
import io.evitadb.externalApi.api.catalog.schemaApi.model.CatalogSchemaDescriptor;
import io.evitadb.externalApi.api.catalog.schemaApi.model.EntitySchemaDescriptor;
import io.evitadb.externalApi.api.catalog.schemaApi.model.EntitySchemasDescriptor;
import io.evitadb.externalApi.api.catalog.schemaApi.model.GlobalAttributeSchemaDescriptor;
import io.evitadb.externalApi.api.catalog.schemaApi.model.GlobalAttributeSchemasDescriptor;
import io.evitadb.externalApi.api.catalog.schemaApi.model.mutation.LocalCatalogSchemaMutationAggregateDescriptor;
import io.evitadb.externalApi.api.catalog.schemaApi.model.mutation.attribute.CreateGlobalAttributeSchemaMutationDescriptor;
import io.evitadb.externalApi.api.catalog.schemaApi.model.mutation.attribute.SetAttributeSchemaGloballyUniqueMutationDescriptor;
import io.evitadb.externalApi.api.catalog.schemaApi.model.mutation.catalog.AllowEvolutionModeInCatalogSchemaMutationDescriptor;
import io.evitadb.externalApi.api.catalog.schemaApi.model.mutation.catalog.DisallowEvolutionModeInCatalogSchemaMutationDescriptor;
import io.evitadb.externalApi.api.catalog.schemaApi.model.mutation.catalog.ModifyCatalogSchemaDescriptionMutationDescriptor;
import io.evitadb.externalApi.api.catalog.schemaApi.model.mutation.catalog.ModifyEntitySchemaMutationDescriptor;
import io.evitadb.externalApi.api.model.ObjectDescriptorTransformer;
import io.evitadb.externalApi.api.model.PropertyDescriptorTransformer;
import io.evitadb.externalApi.rest.api.catalog.builder.CatalogRestBuildingContext;
import io.evitadb.externalApi.rest.api.catalog.schemaApi.model.UpdateCatalogSchemaRequestDescriptor;
import io.evitadb.externalApi.rest.api.model.ObjectDescriptorToOpenApiObjectTransformer;
import io.evitadb.externalApi.rest.api.model.PropertyDescriptorToOpenApiPropertyTransformer;
import io.evitadb.externalApi.rest.api.openApi.OpenApiNonNull;
import io.evitadb.externalApi.rest.api.openApi.OpenApiObject;
import io.evitadb.externalApi.rest.api.openApi.OpenApiProperty;
import io.evitadb.externalApi.rest.api.openApi.OpenApiTypeReference;
import javax.annotation.Nonnull;

public class CatalogSchemaObjectBuilder {
    @Nonnull
    private final CatalogRestBuildingContext buildingContext;
    @Nonnull
    private final ObjectDescriptorToOpenApiObjectTransformer objectBuilderTransformer;
    @Nonnull
    private final PropertyDescriptorToOpenApiPropertyTransformer propertyBuilderTransformer;

    public void buildCommonTypes() {
        this.buildingContext.registerType(((OpenApiObject.Builder)ModifyEntitySchemaMutationDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).build());
        this.buildingContext.registerType(((OpenApiObject.Builder)ModifyCatalogSchemaDescriptionMutationDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).build());
        this.buildingContext.registerType(((OpenApiObject.Builder)AllowEvolutionModeInCatalogSchemaMutationDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).build());
        this.buildingContext.registerType(((OpenApiObject.Builder)DisallowEvolutionModeInCatalogSchemaMutationDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).build());
        this.buildingContext.registerType(((OpenApiObject.Builder)CreateGlobalAttributeSchemaMutationDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).build());
        this.buildingContext.registerType(((OpenApiObject.Builder)SetAttributeSchemaGloballyUniqueMutationDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).build());
        this.buildingContext.registerType(((OpenApiObject.Builder)LocalCatalogSchemaMutationAggregateDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).build());
        this.buildingContext.registerType(((OpenApiObject.Builder)UpdateCatalogSchemaRequestDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).build());
    }

    @Nonnull
    public OpenApiTypeReference build() {
        OpenApiObject.Builder catalogSchemaObjectBuilder = (OpenApiObject.Builder)CatalogSchemaDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer);
        catalogSchemaObjectBuilder.property(this.buildGlobalAttributeSchemasProperty());
        catalogSchemaObjectBuilder.property(this.buildEntitySchemasProperty());
        return this.buildingContext.registerType(catalogSchemaObjectBuilder.build());
    }

    @Nonnull
    private OpenApiProperty buildGlobalAttributeSchemasProperty() {
        return ((OpenApiProperty.Builder)EntitySchemaDescriptor.ATTRIBUTES.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer)).type(OpenApiNonNull.nonNull(this.buildGlobalAttributeSchemasObject())).build();
    }

    @Nonnull
    private OpenApiTypeReference buildGlobalAttributeSchemasObject() {
        CatalogSchemaContract catalogSchema = this.buildingContext.getSchema();
        OpenApiObject.Builder globalAttributeSchemasObjectBuilder = ((OpenApiObject.Builder)GlobalAttributeSchemasDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).name(GlobalAttributeSchemasDescriptor.THIS.name());
        catalogSchema.getAttributes().values().forEach(attributeSchema -> globalAttributeSchemasObjectBuilder.property(this.buildGlobalAttributeSchemaProperty((AttributeSchemaContract)attributeSchema)));
        return this.buildingContext.registerType(globalAttributeSchemasObjectBuilder.build());
    }

    @Nonnull
    private OpenApiProperty buildGlobalAttributeSchemaProperty(@Nonnull AttributeSchemaContract attributeSchema) {
        return OpenApiProperty.newProperty().name(attributeSchema.getNameVariant(ExternalApiNamingConventions.PROPERTY_NAME_NAMING_CONVENTION)).description(attributeSchema.getDescription()).deprecationNotice(attributeSchema.getDeprecationNotice()).type(OpenApiNonNull.nonNull(OpenApiTypeReference.typeRefTo(GlobalAttributeSchemaDescriptor.THIS.name()))).build();
    }

    @Nonnull
    private OpenApiProperty buildEntitySchemasProperty() {
        return ((OpenApiProperty.Builder)CatalogSchemaDescriptor.ENTITY_SCHEMAS.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer)).type(OpenApiNonNull.nonNull(this.buildEntitySchemasObject())).build();
    }

    @Nonnull
    private OpenApiTypeReference buildEntitySchemasObject() {
        OpenApiObject.Builder entitySchemasBuilder = (OpenApiObject.Builder)EntitySchemasDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer);
        this.buildingContext.getEntitySchemas().forEach(entitySchema -> entitySchemasBuilder.property(this.buildEntitySchemaProperty((EntitySchemaContract)entitySchema)));
        return this.buildingContext.registerType(entitySchemasBuilder.build());
    }

    @Nonnull
    private OpenApiProperty buildEntitySchemaProperty(@Nonnull EntitySchemaContract entitySchema) {
        return OpenApiProperty.newProperty().name(entitySchema.getNameVariant(ExternalApiNamingConventions.PROPERTY_NAME_NAMING_CONVENTION)).description(entitySchema.getDescription()).deprecationNotice(entitySchema.getDeprecationNotice()).type(OpenApiNonNull.nonNull(OpenApiTypeReference.typeRefTo(EntitySchemaDescriptor.THIS_SPECIFIC.name(new NamedSchemaContract[]{entitySchema})))).build();
    }

    public CatalogSchemaObjectBuilder(@Nonnull CatalogRestBuildingContext buildingContext, @Nonnull ObjectDescriptorToOpenApiObjectTransformer objectBuilderTransformer, @Nonnull PropertyDescriptorToOpenApiPropertyTransformer propertyBuilderTransformer) {
        if (buildingContext == null) {
            throw new NullPointerException("buildingContext is marked non-null but is null");
        }
        if (objectBuilderTransformer == null) {
            throw new NullPointerException("objectBuilderTransformer is marked non-null but is null");
        }
        if (propertyBuilderTransformer == null) {
            throw new NullPointerException("propertyBuilderTransformer is marked non-null but is null");
        }
        this.buildingContext = buildingContext;
        this.objectBuilderTransformer = objectBuilderTransformer;
        this.propertyBuilderTransformer = propertyBuilderTransformer;
    }
}

