/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.catalog.schemaApi.resolver.endpoint;

import io.evitadb.api.EvitaSessionContract;
import io.evitadb.api.requestResponse.schema.CatalogSchemaContract;
import io.evitadb.externalApi.rest.api.catalog.resolver.endpoint.CatalogRestHandlingContext;
import io.evitadb.externalApi.rest.api.catalog.schemaApi.resolver.serializer.CatalogSchemaJsonSerializer;
import io.evitadb.externalApi.rest.exception.RestInternalError;
import io.evitadb.externalApi.rest.io.JsonRestHandler;
import io.evitadb.externalApi.rest.io.RestEndpointExchange;
import io.evitadb.utils.Assert;
import java.util.LinkedHashSet;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CatalogSchemaHandler
extends JsonRestHandler<CatalogRestHandlingContext> {
    private static final Logger log = LoggerFactory.getLogger(CatalogSchemaHandler.class);
    @Nonnull
    private final CatalogSchemaJsonSerializer catalogSchemaJsonSerializer;

    protected CatalogSchemaHandler(@Nonnull CatalogRestHandlingContext restApiHandlingContext) {
        super(restApiHandlingContext);
        this.catalogSchemaJsonSerializer = new CatalogSchemaJsonSerializer(restApiHandlingContext);
    }

    @Nonnull
    public LinkedHashSet<String> getSupportedResponseContentTypes() {
        return DEFAULT_SUPPORTED_CONTENT_TYPES;
    }

    @Override
    @Nonnull
    protected Object convertResultIntoSerializableObject(@Nonnull RestEndpointExchange exchange, @Nonnull Object catalogSchema) {
        Assert.isPremiseValid((boolean)(catalogSchema instanceof CatalogSchemaContract), () -> new RestInternalError("Expected CatalogSchemaContract, but got `" + catalogSchema.getClass().getName() + "`."));
        return this.catalogSchemaJsonSerializer.serialize((CatalogSchemaContract)catalogSchema, arg_0 -> ((EvitaSessionContract)exchange.session()).getEntitySchemaOrThrow(arg_0), exchange.session().getAllEntityTypes());
    }
}

