/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.catalog.schemaApi.resolver.endpoint;

import io.evitadb.api.EvitaSessionContract;
import io.evitadb.api.requestResponse.schema.EntitySchemaContract;
import io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.endpoint.CollectionRestHandlingContext;
import io.evitadb.externalApi.rest.api.catalog.schemaApi.resolver.serializer.EntitySchemaJsonSerializer;
import io.evitadb.externalApi.rest.exception.RestInternalError;
import io.evitadb.externalApi.rest.io.JsonRestHandler;
import io.evitadb.externalApi.rest.io.RestEndpointExchange;
import io.evitadb.utils.Assert;
import java.util.LinkedHashSet;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EntitySchemaHandler
extends JsonRestHandler<CollectionRestHandlingContext> {
    private static final Logger log = LoggerFactory.getLogger(EntitySchemaHandler.class);
    @Nonnull
    private final EntitySchemaJsonSerializer entitySchemaJsonSerializer;

    protected EntitySchemaHandler(@Nonnull CollectionRestHandlingContext restApiHandlingContext) {
        super(restApiHandlingContext);
        this.entitySchemaJsonSerializer = new EntitySchemaJsonSerializer(restApiHandlingContext);
    }

    @Nonnull
    public LinkedHashSet<String> getSupportedResponseContentTypes() {
        return DEFAULT_SUPPORTED_CONTENT_TYPES;
    }

    @Override
    @Nonnull
    protected Object convertResultIntoSerializableObject(@Nonnull RestEndpointExchange exchange, @Nonnull Object entitySchema) {
        Assert.isPremiseValid((boolean)(entitySchema instanceof EntitySchemaContract), () -> new RestInternalError("Entity schema must be instance of EntitySchemaContract, but was `" + entitySchema.getClass().getName() + "`."));
        return this.entitySchemaJsonSerializer.serialize((EntitySchemaContract)entitySchema, arg_0 -> ((EvitaSessionContract)exchange.session()).getEntitySchemaOrThrow(arg_0));
    }
}

