/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.catalog.schemaApi.resolver.endpoint;

import com.fasterxml.jackson.databind.JsonNode;
import io.evitadb.api.requestResponse.schema.SealedCatalogSchema;
import io.evitadb.api.requestResponse.schema.mutation.LocalCatalogSchemaMutation;
import io.evitadb.externalApi.api.catalog.resolver.mutation.MutationObjectParser;
import io.evitadb.externalApi.api.catalog.resolver.mutation.MutationResolvingExceptionFactory;
import io.evitadb.externalApi.api.catalog.schemaApi.resolver.mutation.LocalCatalogSchemaMutationAggregateConverter;
import io.evitadb.externalApi.http.EndpointResponse;
import io.evitadb.externalApi.http.SuccessEndpointResponse;
import io.evitadb.externalApi.rest.api.catalog.resolver.endpoint.CatalogRestHandlingContext;
import io.evitadb.externalApi.rest.api.catalog.resolver.mutation.RestMutationObjectParser;
import io.evitadb.externalApi.rest.api.catalog.resolver.mutation.RestMutationResolvingExceptionFactory;
import io.evitadb.externalApi.rest.api.catalog.schemaApi.dto.CreateOrUpdateEntitySchemaRequestData;
import io.evitadb.externalApi.rest.api.catalog.schemaApi.resolver.endpoint.CatalogSchemaHandler;
import io.evitadb.externalApi.rest.exception.RestInvalidArgumentException;
import io.evitadb.externalApi.rest.io.RestEndpointExchange;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateCatalogSchemaHandler
extends CatalogSchemaHandler {
    private static final Logger log = LoggerFactory.getLogger(UpdateCatalogSchemaHandler.class);
    @Nonnull
    private final LocalCatalogSchemaMutationAggregateConverter mutationAggregateResolver;

    public UpdateCatalogSchemaHandler(@Nonnull CatalogRestHandlingContext restApiHandlingContext) {
        super(restApiHandlingContext);
        this.mutationAggregateResolver = new LocalCatalogSchemaMutationAggregateConverter((MutationObjectParser)new RestMutationObjectParser(restApiHandlingContext.getObjectMapper()), (MutationResolvingExceptionFactory)new RestMutationResolvingExceptionFactory());
    }

    @Override
    protected boolean modifiesData() {
        return true;
    }

    @Nonnull
    protected EndpointResponse doHandleRequest(@Nonnull RestEndpointExchange exchange) {
        CreateOrUpdateEntitySchemaRequestData requestData = this.parseRequestBody(exchange, CreateOrUpdateEntitySchemaRequestData.class);
        LinkedList schemaMutations = new LinkedList();
        JsonNode inputMutations = requestData.getMutations().orElseThrow(() -> new RestInvalidArgumentException("Mutations are not set in request data."));
        Iterator schemaMutationsIterator = inputMutations.elements();
        while (schemaMutationsIterator.hasNext()) {
            schemaMutations.addAll(this.mutationAggregateResolver.convert(schemaMutationsIterator.next()));
        }
        SealedCatalogSchema updatedCatalogSchema = exchange.session().updateAndFetchCatalogSchema((LocalCatalogSchemaMutation[])schemaMutations.toArray(LocalCatalogSchemaMutation[]::new));
        return new SuccessEndpointResponse(this.convertResultIntoSerializableObject(exchange, updatedCatalogSchema));
    }

    @Nonnull
    public Set<String> getSupportedHttpMethods() {
        return Set.of("PUT");
    }

    @Nonnull
    public Set<String> getSupportedRequestContentTypes() {
        return DEFAULT_SUPPORTED_CONTENT_TYPES;
    }
}

