/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.catalog.schemaApi.resolver.endpoint;

import com.fasterxml.jackson.databind.JsonNode;
import io.evitadb.api.requestResponse.schema.SealedEntitySchema;
import io.evitadb.api.requestResponse.schema.mutation.EntitySchemaMutation;
import io.evitadb.api.requestResponse.schema.mutation.catalog.ModifyEntitySchemaMutation;
import io.evitadb.externalApi.api.catalog.resolver.mutation.MutationObjectParser;
import io.evitadb.externalApi.api.catalog.resolver.mutation.MutationResolvingExceptionFactory;
import io.evitadb.externalApi.api.catalog.schemaApi.resolver.mutation.EntitySchemaMutationAggregateConverter;
import io.evitadb.externalApi.http.EndpointResponse;
import io.evitadb.externalApi.http.SuccessEndpointResponse;
import io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.endpoint.CollectionRestHandlingContext;
import io.evitadb.externalApi.rest.api.catalog.resolver.mutation.RestMutationObjectParser;
import io.evitadb.externalApi.rest.api.catalog.resolver.mutation.RestMutationResolvingExceptionFactory;
import io.evitadb.externalApi.rest.api.catalog.schemaApi.dto.CreateOrUpdateEntitySchemaRequestData;
import io.evitadb.externalApi.rest.api.catalog.schemaApi.resolver.endpoint.EntitySchemaHandler;
import io.evitadb.externalApi.rest.exception.RestInvalidArgumentException;
import io.evitadb.externalApi.rest.io.RestEndpointExchange;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateEntitySchemaHandler
extends EntitySchemaHandler {
    private static final Logger log = LoggerFactory.getLogger(UpdateEntitySchemaHandler.class);
    @Nonnull
    private final EntitySchemaMutationAggregateConverter mutationAggregateResolver;

    public UpdateEntitySchemaHandler(@Nonnull CollectionRestHandlingContext restApiHandlingContext) {
        super(restApiHandlingContext);
        this.mutationAggregateResolver = new EntitySchemaMutationAggregateConverter((MutationObjectParser)new RestMutationObjectParser(restApiHandlingContext.getObjectMapper()), (MutationResolvingExceptionFactory)new RestMutationResolvingExceptionFactory());
    }

    @Override
    protected boolean modifiesData() {
        return true;
    }

    @Nonnull
    protected EndpointResponse doHandleRequest(@Nonnull RestEndpointExchange exchange) {
        CreateOrUpdateEntitySchemaRequestData requestData = this.parseRequestBody(exchange, CreateOrUpdateEntitySchemaRequestData.class);
        LinkedList schemaMutations = new LinkedList();
        JsonNode inputMutations = requestData.getMutations().orElseThrow(() -> new RestInvalidArgumentException("Mutations are not set in request data."));
        Iterator schemaMutationsIterator = inputMutations.elements();
        while (schemaMutationsIterator.hasNext()) {
            schemaMutations.addAll(this.mutationAggregateResolver.convert(schemaMutationsIterator.next()));
        }
        ModifyEntitySchemaMutation entitySchemaMutation = new ModifyEntitySchemaMutation(((CollectionRestHandlingContext)this.restHandlingContext).getEntityType(), (EntitySchemaMutation[])schemaMutations.toArray(EntitySchemaMutation[]::new));
        SealedEntitySchema updatedEntitySchema = exchange.session().updateAndFetchEntitySchema(entitySchemaMutation);
        return new SuccessEndpointResponse(this.convertResultIntoSerializableObject(exchange, updatedEntitySchema));
    }

    @Nonnull
    public Set<String> getSupportedHttpMethods() {
        return Set.of("PUT");
    }

    @Nonnull
    public Set<String> getSupportedRequestContentTypes() {
        return DEFAULT_SUPPORTED_CONTENT_TYPES;
    }
}

