/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.catalog.schemaApi.resolver.serializer;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.evitadb.api.requestResponse.schema.AttributeSchemaProvider;
import io.evitadb.api.requestResponse.schema.CatalogSchemaContract;
import io.evitadb.api.requestResponse.schema.EntitySchemaContract;
import io.evitadb.api.requestResponse.schema.GlobalAttributeSchemaContract;
import io.evitadb.externalApi.api.ExternalApiNamingConventions;
import io.evitadb.externalApi.api.catalog.model.VersionedDescriptor;
import io.evitadb.externalApi.api.catalog.schemaApi.model.AttributeSchemaDescriptor;
import io.evitadb.externalApi.api.catalog.schemaApi.model.CatalogSchemaDescriptor;
import io.evitadb.externalApi.api.catalog.schemaApi.model.EntityAttributeSchemaDescriptor;
import io.evitadb.externalApi.api.catalog.schemaApi.model.GlobalAttributeSchemaDescriptor;
import io.evitadb.externalApi.api.catalog.schemaApi.model.NamedSchemaDescriptor;
import io.evitadb.externalApi.api.catalog.schemaApi.model.NamedSchemaWithDeprecationDescriptor;
import io.evitadb.externalApi.rest.api.catalog.schemaApi.resolver.serializer.EntitySchemaJsonSerializer;
import io.evitadb.externalApi.rest.api.catalog.schemaApi.resolver.serializer.SchemaJsonSerializer;
import io.evitadb.externalApi.rest.api.resolver.serializer.DataTypeSerializer;
import io.evitadb.externalApi.rest.api.resolver.serializer.ObjectJsonSerializer;
import io.evitadb.externalApi.rest.io.RestHandlingContext;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogSchemaJsonSerializer
extends SchemaJsonSerializer {
    private static final Logger log = LoggerFactory.getLogger(CatalogSchemaJsonSerializer.class);
    @Nonnull
    private final EntitySchemaJsonSerializer entitySchemaJsonSerializer;

    public CatalogSchemaJsonSerializer(@Nonnull RestHandlingContext restHandlingContext) {
        super(new ObjectJsonSerializer(restHandlingContext.getObjectMapper()));
        this.entitySchemaJsonSerializer = new EntitySchemaJsonSerializer(restHandlingContext);
    }

    public JsonNode serialize(@Nonnull CatalogSchemaContract catalogSchema, @Nonnull Function<String, EntitySchemaContract> entitySchemaFetcher, @Nonnull Set<String> entityTypes) {
        ObjectNode rootNode = this.objectJsonSerializer.objectNode();
        rootNode.put(VersionedDescriptor.VERSION.name(), catalogSchema.version());
        rootNode.put(NamedSchemaDescriptor.NAME.name(), catalogSchema.getName());
        rootNode.set(NamedSchemaDescriptor.NAME_VARIANTS.name(), (JsonNode)this.serializeNameVariants(catalogSchema.getNameVariants()));
        rootNode.put(NamedSchemaDescriptor.DESCRIPTION.name(), catalogSchema.getDescription());
        rootNode.set(CatalogSchemaDescriptor.ATTRIBUTES.name(), (JsonNode)this.serializeAttributeSchemas((AttributeSchemaProvider<GlobalAttributeSchemaContract>)catalogSchema));
        rootNode.set(CatalogSchemaDescriptor.ENTITY_SCHEMAS.name(), (JsonNode)this.serializeEntitySchemas(entitySchemaFetcher, entityTypes));
        return rootNode;
    }

    @Nonnull
    protected ObjectNode serializeAttributeSchemas(@Nonnull AttributeSchemaProvider<GlobalAttributeSchemaContract> globalAttributeSchemaProvider) {
        Collection globalAttributeSchemas = globalAttributeSchemaProvider.getAttributes().values();
        ObjectNode attributeSchemasMap = this.objectJsonSerializer.objectNode();
        if (!globalAttributeSchemas.isEmpty()) {
            globalAttributeSchemas.forEach(globalAttributeSchema -> attributeSchemasMap.set(globalAttributeSchema.getNameVariant(ExternalApiNamingConventions.PROPERTY_NAME_NAMING_CONVENTION), (JsonNode)this.serializeAttributeSchema((GlobalAttributeSchemaContract)globalAttributeSchema)));
        }
        return attributeSchemasMap;
    }

    @Nonnull
    private ObjectNode serializeAttributeSchema(@Nonnull GlobalAttributeSchemaContract globalAttributeSchema) {
        ObjectNode attributeSchemaNode = this.objectJsonSerializer.objectNode();
        attributeSchemaNode.put(NamedSchemaDescriptor.NAME.name(), globalAttributeSchema.getName());
        attributeSchemaNode.set(NamedSchemaDescriptor.NAME_VARIANTS.name(), (JsonNode)this.serializeNameVariants(globalAttributeSchema.getNameVariants()));
        attributeSchemaNode.put(NamedSchemaDescriptor.DESCRIPTION.name(), globalAttributeSchema.getDescription());
        attributeSchemaNode.put(NamedSchemaWithDeprecationDescriptor.DEPRECATION_NOTICE.name(), globalAttributeSchema.getDeprecationNotice());
        attributeSchemaNode.put(AttributeSchemaDescriptor.UNIQUENESS_TYPE.name(), globalAttributeSchema.getUniquenessType().toString());
        attributeSchemaNode.put(GlobalAttributeSchemaDescriptor.GLOBAL_UNIQUENESS_TYPE.name(), globalAttributeSchema.getGlobalUniquenessType().toString());
        attributeSchemaNode.put(AttributeSchemaDescriptor.FILTERABLE.name(), globalAttributeSchema.isFilterable());
        attributeSchemaNode.put(AttributeSchemaDescriptor.SORTABLE.name(), globalAttributeSchema.isSortable());
        attributeSchemaNode.put(AttributeSchemaDescriptor.LOCALIZED.name(), globalAttributeSchema.isLocalized());
        attributeSchemaNode.put(AttributeSchemaDescriptor.NULLABLE.name(), globalAttributeSchema.isNullable());
        attributeSchemaNode.put(EntityAttributeSchemaDescriptor.REPRESENTATIVE.name(), globalAttributeSchema.isRepresentative());
        attributeSchemaNode.put(AttributeSchemaDescriptor.TYPE.name(), DataTypeSerializer.serialize(globalAttributeSchema.getType()));
        attributeSchemaNode.set(AttributeSchemaDescriptor.DEFAULT_VALUE.name(), (JsonNode)Optional.ofNullable(globalAttributeSchema.getDefaultValue()).map(this.objectJsonSerializer::serializeObject).orElse(null));
        attributeSchemaNode.put(AttributeSchemaDescriptor.INDEXED_DECIMAL_PLACES.name(), globalAttributeSchema.getIndexedDecimalPlaces());
        return attributeSchemaNode;
    }

    @Nonnull
    private ObjectNode serializeEntitySchemas(@Nonnull Function<String, EntitySchemaContract> entitySchemaFetcher, @Nonnull Set<String> entityTypes) {
        ObjectNode entitySchemasMap = this.objectJsonSerializer.objectNode();
        if (!entityTypes.isEmpty()) {
            entityTypes.stream().map(entitySchemaFetcher).forEach(entitySchema -> entitySchemasMap.set(entitySchema.getNameVariant(ExternalApiNamingConventions.PROPERTY_NAME_NAMING_CONVENTION), this.entitySchemaJsonSerializer.serialize((EntitySchemaContract)entitySchema, entitySchemaFetcher)));
        }
        return entitySchemasMap;
    }
}

