/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.catalog.schemaApi.resolver.serializer;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.evitadb.api.requestResponse.schema.AssociatedDataSchemaContract;
import io.evitadb.api.requestResponse.schema.AttributeSchemaContract;
import io.evitadb.api.requestResponse.schema.AttributeSchemaProvider;
import io.evitadb.api.requestResponse.schema.EntityAttributeSchemaContract;
import io.evitadb.api.requestResponse.schema.EntitySchemaContract;
import io.evitadb.api.requestResponse.schema.GlobalAttributeSchemaContract;
import io.evitadb.api.requestResponse.schema.ReferenceSchemaContract;
import io.evitadb.api.requestResponse.schema.SortableAttributeCompoundSchemaContract;
import io.evitadb.api.requestResponse.schema.SortableAttributeCompoundSchemaProvider;
import io.evitadb.externalApi.api.ExternalApiNamingConventions;
import io.evitadb.externalApi.api.catalog.model.VersionedDescriptor;
import io.evitadb.externalApi.api.catalog.schemaApi.model.AssociatedDataSchemaDescriptor;
import io.evitadb.externalApi.api.catalog.schemaApi.model.AttributeElementDescriptor;
import io.evitadb.externalApi.api.catalog.schemaApi.model.AttributeSchemaDescriptor;
import io.evitadb.externalApi.api.catalog.schemaApi.model.EntityAttributeSchemaDescriptor;
import io.evitadb.externalApi.api.catalog.schemaApi.model.EntitySchemaDescriptor;
import io.evitadb.externalApi.api.catalog.schemaApi.model.GlobalAttributeSchemaDescriptor;
import io.evitadb.externalApi.api.catalog.schemaApi.model.NamedSchemaDescriptor;
import io.evitadb.externalApi.api.catalog.schemaApi.model.NamedSchemaWithDeprecationDescriptor;
import io.evitadb.externalApi.api.catalog.schemaApi.model.ReferenceSchemaDescriptor;
import io.evitadb.externalApi.api.catalog.schemaApi.model.SortableAttributeCompoundSchemaDescriptor;
import io.evitadb.externalApi.api.catalog.schemaApi.model.SortableAttributeCompoundsSchemaProviderDescriptor;
import io.evitadb.externalApi.rest.api.catalog.schemaApi.resolver.serializer.SchemaJsonSerializer;
import io.evitadb.externalApi.rest.api.resolver.serializer.DataTypeSerializer;
import io.evitadb.externalApi.rest.api.resolver.serializer.ObjectJsonSerializer;
import io.evitadb.externalApi.rest.io.RestHandlingContext;
import java.util.Collection;
import java.util.Currency;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntitySchemaJsonSerializer
extends SchemaJsonSerializer {
    private static final Logger log = LoggerFactory.getLogger(EntitySchemaJsonSerializer.class);

    public EntitySchemaJsonSerializer(@Nonnull RestHandlingContext restHandlingContext) {
        super(new ObjectJsonSerializer(restHandlingContext.getObjectMapper()));
    }

    public JsonNode serialize(@Nonnull EntitySchemaContract entitySchema, @Nonnull Function<String, EntitySchemaContract> entitySchemaFetcher) {
        ObjectNode rootNode = this.objectJsonSerializer.objectNode();
        rootNode.put(VersionedDescriptor.VERSION.name(), entitySchema.version());
        rootNode.put(NamedSchemaDescriptor.NAME.name(), entitySchema.getName());
        rootNode.set(NamedSchemaDescriptor.NAME_VARIANTS.name(), (JsonNode)this.serializeNameVariants(entitySchema.getNameVariants()));
        rootNode.put(NamedSchemaDescriptor.DESCRIPTION.name(), entitySchema.getDescription());
        rootNode.put(NamedSchemaWithDeprecationDescriptor.DEPRECATION_NOTICE.name(), entitySchema.getDeprecationNotice());
        rootNode.put(EntitySchemaDescriptor.WITH_GENERATED_PRIMARY_KEY.name(), entitySchema.isWithGeneratedPrimaryKey());
        rootNode.put(EntitySchemaDescriptor.WITH_HIERARCHY.name(), entitySchema.isWithHierarchy());
        rootNode.put(EntitySchemaDescriptor.WITH_PRICE.name(), entitySchema.isWithPrice());
        rootNode.put(EntitySchemaDescriptor.INDEXED_PRICE_PLACES.name(), entitySchema.getIndexedPricePlaces());
        rootNode.set(EntitySchemaDescriptor.LOCALES.name(), this.objectJsonSerializer.serializeCollection(entitySchema.getLocales().stream().map(Locale::toLanguageTag).toList()));
        rootNode.set(EntitySchemaDescriptor.CURRENCIES.name(), this.objectJsonSerializer.serializeCollection(entitySchema.getCurrencies().stream().map(Currency::toString).toList()));
        rootNode.set(EntitySchemaDescriptor.EVOLUTION_MODE.name(), this.objectJsonSerializer.serializeCollection(entitySchema.getEvolutionMode().stream().map(Enum::name).toList()));
        rootNode.set(EntitySchemaDescriptor.ATTRIBUTES.name(), (JsonNode)this.serializeAttributeSchemas((AttributeSchemaProvider<? extends AttributeSchemaContract>)entitySchema));
        rootNode.set(SortableAttributeCompoundsSchemaProviderDescriptor.SORTABLE_ATTRIBUTE_COMPOUNDS.name(), (JsonNode)this.serializeSortableAttributeCompoundSchemas((SortableAttributeCompoundSchemaProvider)entitySchema));
        rootNode.set(EntitySchemaDescriptor.ASSOCIATED_DATA.name(), (JsonNode)this.serializeAssociatedDataSchemas(entitySchema));
        rootNode.set(EntitySchemaDescriptor.REFERENCES.name(), (JsonNode)this.serializeReferenceSchemas(entitySchemaFetcher, entitySchema));
        return rootNode;
    }

    @Nonnull
    private ObjectNode serializeAttributeSchemas(@Nonnull AttributeSchemaProvider<? extends AttributeSchemaContract> attributeSchemaProvider) {
        Collection attributeSchemas = attributeSchemaProvider.getAttributes().values();
        ObjectNode attributeSchemasMap = this.objectJsonSerializer.objectNode();
        if (!attributeSchemas.isEmpty()) {
            attributeSchemas.forEach(attributeSchema -> attributeSchemasMap.set(attributeSchema.getNameVariant(ExternalApiNamingConventions.PROPERTY_NAME_NAMING_CONVENTION), (JsonNode)this.serializeAttributeSchema((AttributeSchemaContract)attributeSchema)));
        }
        return attributeSchemasMap;
    }

    @Nonnull
    private ObjectNode serializeAttributeSchema(@Nonnull AttributeSchemaContract attributeSchema) {
        ObjectNode attributeSchemaNode = this.objectJsonSerializer.objectNode();
        attributeSchemaNode.put(NamedSchemaDescriptor.NAME.name(), attributeSchema.getName());
        attributeSchemaNode.set(NamedSchemaDescriptor.NAME_VARIANTS.name(), (JsonNode)this.serializeNameVariants(attributeSchema.getNameVariants()));
        attributeSchemaNode.put(NamedSchemaDescriptor.DESCRIPTION.name(), attributeSchema.getDescription());
        attributeSchemaNode.put(NamedSchemaWithDeprecationDescriptor.DEPRECATION_NOTICE.name(), attributeSchema.getDeprecationNotice());
        attributeSchemaNode.put(AttributeSchemaDescriptor.UNIQUENESS_TYPE.name(), attributeSchema.getUniquenessType().toString());
        if (attributeSchema instanceof GlobalAttributeSchemaContract) {
            GlobalAttributeSchemaContract globalAttributeSchema = (GlobalAttributeSchemaContract)attributeSchema;
            attributeSchemaNode.put(GlobalAttributeSchemaDescriptor.GLOBAL_UNIQUENESS_TYPE.name(), globalAttributeSchema.getGlobalUniquenessType().toString());
        }
        attributeSchemaNode.put(AttributeSchemaDescriptor.FILTERABLE.name(), attributeSchema.isFilterable());
        attributeSchemaNode.put(AttributeSchemaDescriptor.SORTABLE.name(), attributeSchema.isSortable());
        attributeSchemaNode.put(AttributeSchemaDescriptor.LOCALIZED.name(), attributeSchema.isLocalized());
        attributeSchemaNode.put(AttributeSchemaDescriptor.NULLABLE.name(), attributeSchema.isNullable());
        if (attributeSchema instanceof EntityAttributeSchemaContract) {
            EntityAttributeSchemaContract entityAttributeSchema = (EntityAttributeSchemaContract)attributeSchema;
            attributeSchemaNode.put(EntityAttributeSchemaDescriptor.REPRESENTATIVE.name(), entityAttributeSchema.isRepresentative());
        }
        attributeSchemaNode.put(AttributeSchemaDescriptor.TYPE.name(), DataTypeSerializer.serialize(attributeSchema.getType()));
        attributeSchemaNode.set(AttributeSchemaDescriptor.DEFAULT_VALUE.name(), (JsonNode)Optional.ofNullable(attributeSchema.getDefaultValue()).map(this.objectJsonSerializer::serializeObject).orElse(null));
        attributeSchemaNode.put(AttributeSchemaDescriptor.INDEXED_DECIMAL_PLACES.name(), attributeSchema.getIndexedDecimalPlaces());
        return attributeSchemaNode;
    }

    @Nonnull
    private ObjectNode serializeSortableAttributeCompoundSchemas(@Nonnull SortableAttributeCompoundSchemaProvider provider) {
        Collection schemas = provider.getSortableAttributeCompounds().values();
        ObjectNode attributeSchemasMap = this.objectJsonSerializer.objectNode();
        if (!schemas.isEmpty()) {
            schemas.forEach(attributeSchema -> attributeSchemasMap.set(attributeSchema.getNameVariant(ExternalApiNamingConventions.PROPERTY_NAME_NAMING_CONVENTION), (JsonNode)this.serializeSortableAttributeCompoundSchema((SortableAttributeCompoundSchemaContract)attributeSchema)));
        }
        return attributeSchemasMap;
    }

    @Nonnull
    private ObjectNode serializeSortableAttributeCompoundSchema(@Nonnull SortableAttributeCompoundSchemaContract sortableAttributeCompoundSchema) {
        ObjectNode schemaNode = this.objectJsonSerializer.objectNode();
        schemaNode.put(NamedSchemaDescriptor.NAME.name(), sortableAttributeCompoundSchema.getName());
        schemaNode.set(NamedSchemaDescriptor.NAME_VARIANTS.name(), (JsonNode)this.serializeNameVariants(sortableAttributeCompoundSchema.getNameVariants()));
        schemaNode.put(NamedSchemaDescriptor.DESCRIPTION.name(), sortableAttributeCompoundSchema.getDescription());
        schemaNode.put(NamedSchemaWithDeprecationDescriptor.DEPRECATION_NOTICE.name(), sortableAttributeCompoundSchema.getDeprecationNotice());
        ArrayNode sortableAttributeCompoundArray = this.objectJsonSerializer.arrayNode();
        sortableAttributeCompoundSchema.getAttributeElements().forEach(it -> sortableAttributeCompoundArray.add((JsonNode)this.serializeAttributeElement((SortableAttributeCompoundSchemaContract.AttributeElement)it)));
        schemaNode.putIfAbsent(SortableAttributeCompoundSchemaDescriptor.ATTRIBUTE_ELEMENTS.name(), (JsonNode)sortableAttributeCompoundArray);
        return schemaNode;
    }

    @Nonnull
    private ObjectNode serializeAttributeElement(@Nonnull SortableAttributeCompoundSchemaContract.AttributeElement attributeElement) {
        ObjectNode attributeElementNode = this.objectJsonSerializer.objectNode();
        attributeElementNode.put(AttributeElementDescriptor.ATTRIBUTE_NAME.name(), attributeElement.attributeName());
        attributeElementNode.put(AttributeElementDescriptor.DIRECTION.name(), attributeElement.direction().name());
        attributeElementNode.put(AttributeElementDescriptor.BEHAVIOUR.name(), attributeElement.behaviour().name());
        return attributeElementNode;
    }

    @Nonnull
    private ObjectNode serializeAssociatedDataSchemas(@Nonnull EntitySchemaContract entitySchema) {
        Collection associatedDataSchemas = entitySchema.getAssociatedData().values();
        ObjectNode associatedDataSchemasMap = this.objectJsonSerializer.objectNode();
        if (!associatedDataSchemas.isEmpty()) {
            associatedDataSchemas.forEach(associatedDataSchema -> associatedDataSchemasMap.set(associatedDataSchema.getNameVariant(ExternalApiNamingConventions.PROPERTY_NAME_NAMING_CONVENTION), (JsonNode)this.serializeAssociatedDataSchema((AssociatedDataSchemaContract)associatedDataSchema)));
        }
        return associatedDataSchemasMap;
    }

    @Nonnull
    private ObjectNode serializeAssociatedDataSchema(@Nonnull AssociatedDataSchemaContract associatedDataSchema) {
        ObjectNode associatedDataSchemaNode = this.objectJsonSerializer.objectNode();
        associatedDataSchemaNode.put(NamedSchemaDescriptor.NAME.name(), associatedDataSchema.getName());
        associatedDataSchemaNode.set(NamedSchemaDescriptor.NAME_VARIANTS.name(), (JsonNode)this.serializeNameVariants(associatedDataSchema.getNameVariants()));
        associatedDataSchemaNode.put(NamedSchemaDescriptor.DESCRIPTION.name(), associatedDataSchema.getDescription());
        associatedDataSchemaNode.put(NamedSchemaWithDeprecationDescriptor.DEPRECATION_NOTICE.name(), associatedDataSchema.getDeprecationNotice());
        associatedDataSchemaNode.put(AssociatedDataSchemaDescriptor.TYPE.name(), DataTypeSerializer.serialize(associatedDataSchema.getType()));
        associatedDataSchemaNode.put(AssociatedDataSchemaDescriptor.LOCALIZED.name(), associatedDataSchema.isLocalized());
        associatedDataSchemaNode.put(AssociatedDataSchemaDescriptor.NULLABLE.name(), associatedDataSchema.isNullable());
        return associatedDataSchemaNode;
    }

    @Nonnull
    private ObjectNode serializeReferenceSchemas(@Nonnull Function<String, EntitySchemaContract> entitySchemaFetcher, @Nonnull EntitySchemaContract entitySchema) {
        Collection referenceSchemas = entitySchema.getReferences().values();
        ObjectNode referenceSchemasMap = this.objectJsonSerializer.objectNode();
        if (!referenceSchemas.isEmpty()) {
            referenceSchemas.forEach(referenceSchema -> referenceSchemasMap.set(referenceSchema.getNameVariant(ExternalApiNamingConventions.PROPERTY_NAME_NAMING_CONVENTION), (JsonNode)this.serializeReferenceSchema(entitySchemaFetcher, (ReferenceSchemaContract)referenceSchema)));
        }
        return referenceSchemasMap;
    }

    @Nonnull
    private ObjectNode serializeReferenceSchema(@Nonnull Function<String, EntitySchemaContract> entitySchemaFetcher, @Nonnull ReferenceSchemaContract referenceSchema) {
        ObjectNode referenceSchemaNode = this.objectJsonSerializer.objectNode();
        referenceSchemaNode.put(NamedSchemaDescriptor.NAME.name(), referenceSchema.getName());
        referenceSchemaNode.set(NamedSchemaDescriptor.NAME_VARIANTS.name(), (JsonNode)this.serializeNameVariants(referenceSchema.getNameVariants()));
        referenceSchemaNode.put(NamedSchemaDescriptor.DESCRIPTION.name(), referenceSchema.getDescription());
        referenceSchemaNode.put(NamedSchemaWithDeprecationDescriptor.DEPRECATION_NOTICE.name(), referenceSchema.getDeprecationNotice());
        referenceSchemaNode.put(ReferenceSchemaDescriptor.CARDINALITY.name(), referenceSchema.getCardinality().name());
        referenceSchemaNode.put(ReferenceSchemaDescriptor.REFERENCED_ENTITY_TYPE.name(), referenceSchema.getReferencedEntityType());
        referenceSchemaNode.set(ReferenceSchemaDescriptor.ENTITY_TYPE_NAME_VARIANTS.name(), (JsonNode)this.serializeNameVariants(referenceSchema.getEntityTypeNameVariants(entitySchemaFetcher)));
        referenceSchemaNode.put(ReferenceSchemaDescriptor.REFERENCED_ENTITY_TYPE_MANAGED.name(), referenceSchema.isReferencedEntityTypeManaged());
        referenceSchemaNode.put(ReferenceSchemaDescriptor.REFERENCED_GROUP_TYPE.name(), referenceSchema.getReferencedGroupType());
        referenceSchemaNode.set(ReferenceSchemaDescriptor.GROUP_TYPE_NAME_VARIANTS.name(), (JsonNode)this.serializeNameVariants(referenceSchema.getGroupTypeNameVariants(entitySchemaFetcher)));
        referenceSchemaNode.put(ReferenceSchemaDescriptor.REFERENCED_GROUP_TYPE_MANAGED.name(), referenceSchema.isReferencedGroupTypeManaged());
        referenceSchemaNode.put(ReferenceSchemaDescriptor.INDEXED.name(), referenceSchema.isIndexed());
        referenceSchemaNode.put(ReferenceSchemaDescriptor.FACETED.name(), referenceSchema.isFaceted());
        referenceSchemaNode.set(ReferenceSchemaDescriptor.ATTRIBUTES.name(), (JsonNode)this.serializeAttributeSchemas((AttributeSchemaProvider<? extends AttributeSchemaContract>)referenceSchema));
        referenceSchemaNode.set(SortableAttributeCompoundsSchemaProviderDescriptor.SORTABLE_ATTRIBUTE_COMPOUNDS.name(), (JsonNode)this.serializeSortableAttributeCompoundSchemas((SortableAttributeCompoundSchemaProvider)referenceSchema));
        return referenceSchemaNode;
    }
}

