/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.dataType;

import io.evitadb.externalApi.rest.api.openApi.OpenApiArray;
import io.evitadb.externalApi.rest.api.openApi.OpenApiEnum;
import io.evitadb.externalApi.rest.api.openApi.OpenApiNonNull;
import io.evitadb.externalApi.rest.api.openApi.OpenApiScalar;
import io.evitadb.externalApi.rest.api.openApi.OpenApiSimpleType;
import io.evitadb.externalApi.rest.api.openApi.OpenApiTypeReference;
import javax.annotation.Nonnull;

public class DataTypesConverter {
    public static OpenApiSimpleType getOpenApiScalar(@Nonnull Class<?> javaDataType) {
        return DataTypesConverter.getOpenApiScalar(javaDataType, false);
    }

    public static OpenApiSimpleType getOpenApiScalar(@Nonnull Class<?> javaDataType, boolean nonNull) {
        Class<?> componentType = javaDataType.isArray() ? javaDataType.getComponentType() : javaDataType;
        OpenApiScalar openApiComponentType = OpenApiScalar.scalarFrom(componentType);
        return DataTypesConverter.wrapOpenApiComponentType(openApiComponentType, javaDataType, nonNull);
    }

    public static OpenApiSimpleType getOpenApiScalar(@Nonnull Class<?> javaDataType, @Nonnull Class<?> replacementComponentType, boolean nonNull) {
        OpenApiScalar openApiComponentType = OpenApiScalar.scalarFrom(replacementComponentType);
        return DataTypesConverter.wrapOpenApiComponentType(openApiComponentType, javaDataType, nonNull);
    }

    public static ConvertedEnum getOpenApiEnum(@Nonnull Class<?> javaEnumType) {
        return DataTypesConverter.getOpenApiEnum(javaEnumType, false);
    }

    public static ConvertedEnum getOpenApiEnum(@Nonnull Class<?> javaEnumType, boolean required) {
        Class<?> componentType = javaEnumType.isArray() ? javaEnumType.getComponentType() : javaEnumType;
        OpenApiEnum openApiEnum = OpenApiEnum.enumFrom(componentType);
        OpenApiSimpleType openApiType = DataTypesConverter.wrapOpenApiComponentType(OpenApiTypeReference.typeRefTo(openApiEnum.getName()), javaEnumType, required);
        return new ConvertedEnum(openApiType, openApiEnum);
    }

    public static ConvertedEnum getOpenApiEnum(@Nonnull Class<?> javaEnumType, @Nonnull Class<?> replacementComponentType, boolean required) {
        Class<?> componentType = replacementComponentType;
        OpenApiEnum openApiEnum = OpenApiEnum.enumFrom(componentType);
        OpenApiSimpleType openApiType = DataTypesConverter.wrapOpenApiComponentType(OpenApiTypeReference.typeRefTo(openApiEnum.getName()), javaEnumType, required);
        return new ConvertedEnum(openApiType, openApiEnum);
    }

    public static OpenApiSimpleType wrapOpenApiComponentType(@Nonnull OpenApiSimpleType convertedOpenApiComponentType, @Nonnull Class<?> javaDataType, boolean nonNull) {
        OpenApiSimpleType openApiType = javaDataType.isArray() ? OpenApiArray.arrayOf(convertedOpenApiComponentType) : convertedOpenApiComponentType;
        if (nonNull) {
            openApiType = OpenApiNonNull.nonNull(openApiType);
        }
        return openApiType;
    }

    private DataTypesConverter() {
    }

    public record ConvertedEnum(@Nonnull OpenApiSimpleType resultType, @Nonnull OpenApiEnum enumType) {
    }
}

