/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.model;

import io.evitadb.externalApi.api.model.ObjectPropertyDataTypeDescriptor;
import io.evitadb.externalApi.api.model.PrimitivePropertyDataTypeDescriptor;
import io.evitadb.externalApi.api.model.PropertyDataTypeDescriptor;
import io.evitadb.externalApi.api.model.PropertyDataTypeDescriptorTransformer;
import io.evitadb.externalApi.rest.api.builder.RestBuildingContext;
import io.evitadb.externalApi.rest.api.dataType.DataTypesConverter;
import io.evitadb.externalApi.rest.api.openApi.OpenApiArray;
import io.evitadb.externalApi.rest.api.openApi.OpenApiNonNull;
import io.evitadb.externalApi.rest.api.openApi.OpenApiSimpleType;
import io.evitadb.externalApi.rest.api.openApi.OpenApiTypeReference;
import io.evitadb.externalApi.rest.exception.OpenApiBuildingError;
import javax.annotation.Nonnull;

public class PropertyDataTypeDescriptorToOpenApiTypeTransformer
implements PropertyDataTypeDescriptorTransformer<OpenApiSimpleType> {
    @Nonnull
    private final RestBuildingContext restBuildingContext;

    public OpenApiSimpleType apply(@Nonnull PropertyDataTypeDescriptor typeDescriptor) {
        if (typeDescriptor instanceof PrimitivePropertyDataTypeDescriptor) {
            PrimitivePropertyDataTypeDescriptor primitiveType = (PrimitivePropertyDataTypeDescriptor)typeDescriptor;
            if (primitiveType.javaType().isEnum() || primitiveType.javaType().isArray() && ((Class)primitiveType.javaType().componentType()).isEnum()) {
                DataTypesConverter.ConvertedEnum enumType = DataTypesConverter.getOpenApiEnum(primitiveType.javaType(), primitiveType.nonNull());
                this.restBuildingContext.registerCustomEnumIfAbsent(enumType.enumType());
                return enumType.resultType();
            }
            return DataTypesConverter.getOpenApiScalar(primitiveType.javaType(), primitiveType.nonNull());
        }
        if (typeDescriptor instanceof ObjectPropertyDataTypeDescriptor) {
            ObjectPropertyDataTypeDescriptor objectType = (ObjectPropertyDataTypeDescriptor)typeDescriptor;
            OpenApiSimpleType openApiType = OpenApiTypeReference.typeRefTo(objectType.objectReference().name());
            if (objectType.list()) {
                openApiType = OpenApiArray.arrayOf(openApiType);
            }
            if (objectType.nonNull()) {
                openApiType = OpenApiNonNull.nonNull(openApiType);
            }
            return openApiType;
        }
        throw new OpenApiBuildingError("Unsupported property data type `" + typeDescriptor.getClass().getName() + "`.");
    }

    public PropertyDataTypeDescriptorToOpenApiTypeTransformer(@Nonnull RestBuildingContext restBuildingContext) {
        if (restBuildingContext == null) {
            throw new NullPointerException("restBuildingContext is marked non-null but is null");
        }
        this.restBuildingContext = restBuildingContext;
    }
}

