/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.model;

import io.evitadb.externalApi.api.model.PropertyDataTypeDescriptorTransformer;
import io.evitadb.externalApi.api.model.PropertyDescriptor;
import io.evitadb.externalApi.api.model.PropertyDescriptorTransformer;
import io.evitadb.externalApi.rest.api.openApi.OpenApiProperty;
import io.evitadb.externalApi.rest.api.openApi.OpenApiSimpleType;
import io.evitadb.externalApi.rest.exception.OpenApiBuildingError;
import io.evitadb.utils.Assert;
import javax.annotation.Nonnull;

public class PropertyDescriptorToOpenApiPropertyTransformer
implements PropertyDescriptorTransformer<OpenApiProperty.Builder> {
    @Nonnull
    private final PropertyDataTypeDescriptorTransformer<OpenApiSimpleType> propertyDataTypeDescriptorTransformer;

    public OpenApiProperty.Builder apply(@Nonnull PropertyDescriptor propertyDescriptor) {
        OpenApiProperty.Builder propertyBuilder = OpenApiProperty.newProperty().name(propertyDescriptor.name()).description(propertyDescriptor.description());
        Assert.isPremiseValid((propertyDescriptor.defaultValue() == null ? 1 : 0) != 0, () -> new OpenApiBuildingError("Default values are not supported in REST API right now."));
        if (propertyDescriptor.type() != null) {
            OpenApiSimpleType openApiType = (OpenApiSimpleType)this.propertyDataTypeDescriptorTransformer.apply((Object)propertyDescriptor.type());
            propertyBuilder.type(openApiType);
        }
        return propertyBuilder;
    }

    public PropertyDescriptorToOpenApiPropertyTransformer(@Nonnull PropertyDataTypeDescriptorTransformer<OpenApiSimpleType> propertyDataTypeDescriptorTransformer) {
        if (propertyDataTypeDescriptorTransformer == null) {
            throw new NullPointerException("propertyDataTypeDescriptorTransformer is marked non-null but is null");
        }
        this.propertyDataTypeDescriptorTransformer = propertyDataTypeDescriptorTransformer;
    }
}

