/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.openApi;

import io.evitadb.externalApi.rest.api.openApi.OpenApiSimpleType;
import io.evitadb.externalApi.rest.api.openApi.OpenApiWrappingType;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OpenApiArray
implements OpenApiWrappingType {
    @Nonnull
    private final OpenApiSimpleType itemType;
    @Nullable
    private final Integer minItems;
    @Nullable
    private final Integer maxItems;

    @Nonnull
    public static OpenApiArray arrayOf(@Nonnull OpenApiSimpleType itemType) {
        return new OpenApiArray(itemType, null, null);
    }

    @Nonnull
    public static OpenApiArray arrayOf(@Nonnull OpenApiSimpleType itemType, int minItems, int maxItems) {
        return new OpenApiArray(itemType, minItems, maxItems);
    }

    @Override
    @Nonnull
    public OpenApiSimpleType getWrappedType() {
        return this.itemType;
    }

    @Override
    @Nonnull
    public Schema<?> toSchema() {
        ArraySchema schema = new ArraySchema();
        schema.setItems(this.itemType.toSchema());
        schema.minItems(this.minItems);
        schema.maxItems(this.maxItems);
        return schema;
    }

    private OpenApiArray(@Nonnull OpenApiSimpleType itemType, @Nullable Integer minItems, @Nullable Integer maxItems) {
        if (itemType == null) {
            throw new NullPointerException("itemType is marked non-null but is null");
        }
        this.itemType = itemType;
        this.minItems = minItems;
        this.maxItems = maxItems;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenApiArray)) {
            return false;
        }
        OpenApiArray other = (OpenApiArray)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$minItems = this.minItems;
        Integer other$minItems = other.minItems;
        if (this$minItems == null ? other$minItems != null : !((Object)this$minItems).equals(other$minItems)) {
            return false;
        }
        Integer this$maxItems = this.maxItems;
        Integer other$maxItems = other.maxItems;
        if (this$maxItems == null ? other$maxItems != null : !((Object)this$maxItems).equals(other$maxItems)) {
            return false;
        }
        OpenApiSimpleType this$itemType = this.itemType;
        OpenApiSimpleType other$itemType = other.itemType;
        return !(this$itemType == null ? other$itemType != null : !this$itemType.equals(other$itemType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OpenApiArray;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $minItems = this.minItems;
        result = result * 59 + ($minItems == null ? 43 : ((Object)$minItems).hashCode());
        Integer $maxItems = this.maxItems;
        result = result * 59 + ($maxItems == null ? 43 : ((Object)$maxItems).hashCode());
        OpenApiSimpleType $itemType = this.itemType;
        result = result * 59 + ($itemType == null ? 43 : $itemType.hashCode());
        return result;
    }

    public String toString() {
        return "OpenApiArray(itemType=" + this.itemType + ", minItems=" + this.minItems + ", maxItems=" + this.maxItems + ")";
    }
}

