/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.openApi;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.evitadb.api.requestResponse.schema.CatalogSchemaContract;
import io.evitadb.api.requestResponse.schema.EntitySchemaContract;
import io.evitadb.core.Evita;
import io.evitadb.externalApi.api.catalog.dataApi.model.CatalogDataApiRootDescriptor;
import io.evitadb.externalApi.rest.api.catalog.dataApi.model.header.EndpointHeaderDescriptor;
import io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.endpoint.CollectionRestHandlingContext;
import io.evitadb.externalApi.rest.api.openApi.OpenApiEndpoint;
import io.evitadb.externalApi.rest.api.openApi.OpenApiEndpointParameter;
import io.evitadb.externalApi.rest.api.openApi.OpenApiSimpleType;
import io.evitadb.externalApi.rest.api.openApi.OpenApiTypeReference;
import io.evitadb.externalApi.rest.exception.OpenApiBuildingError;
import io.evitadb.externalApi.rest.io.RestEndpointHandler;
import io.evitadb.externalApi.utils.UriPath;
import io.evitadb.utils.Assert;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OpenApiCollectionEndpoint
extends OpenApiEndpoint<CollectionRestHandlingContext> {
    @Nonnull
    protected final CatalogSchemaContract catalogSchema;
    @Nonnull
    private final EntitySchemaContract entitySchema;

    private OpenApiCollectionEndpoint(@Nonnull CatalogSchemaContract catalogSchema, @Nonnull EntitySchemaContract entitySchema, @Nonnull PathItem.HttpMethod method, @Nonnull UriPath path, boolean localized, @Nonnull String operationId, @Nonnull String description, @Nullable String deprecationNotice, @Nonnull List<OpenApiEndpointParameter> parameters, @Nullable OpenApiSimpleType requestBody, @Nonnull OpenApiSimpleType successResponse, @Nonnull Function<CollectionRestHandlingContext, RestEndpointHandler<CollectionRestHandlingContext>> handlerBuilder) {
        super(method, path, localized, operationId, description, deprecationNotice, parameters, requestBody, successResponse, handlerBuilder);
        this.catalogSchema = catalogSchema;
        this.entitySchema = entitySchema;
    }

    @Nonnull
    public static Builder newCollectionEndpoint(@Nonnull CatalogSchemaContract catalogSchema, @Nonnull EntitySchemaContract entitySchema) {
        return new Builder(catalogSchema, entitySchema);
    }

    @Override
    @Nonnull
    public RestEndpointHandler<CollectionRestHandlingContext> toHandler(@Nonnull ObjectMapper objectMapper, @Nonnull Evita evita, @Nonnull OpenAPI openApi, @Nonnull Map<String, Class<? extends Enum<?>>> enumMapping) {
        CollectionRestHandlingContext context = new CollectionRestHandlingContext(objectMapper, evita, this.catalogSchema, this.entitySchema, openApi, enumMapping, this.toOperation(), this.localized);
        return (RestEndpointHandler)((Object)this.handlerBuilder.apply(context));
    }

    public static class Builder {
        @Nonnull
        private final CatalogSchemaContract catalogSchema;
        @Nonnull
        private final EntitySchemaContract entitySchema;
        @Nullable
        private PathItem.HttpMethod method;
        @Nullable
        private UriPath path;
        private boolean localized;
        @Nullable
        private String operationId;
        @Nullable
        private String description;
        @Nullable
        private String deprecationNotice;
        @Nonnull
        private final List<OpenApiEndpointParameter> parameters;
        @Nullable
        private OpenApiSimpleType requestBody;
        @Nullable
        private OpenApiSimpleType successResponse;
        @Nullable
        private Function<CollectionRestHandlingContext, RestEndpointHandler<CollectionRestHandlingContext>> handlerBuilder;

        private Builder(@Nonnull CatalogSchemaContract catalogSchema, @Nonnull EntitySchemaContract entitySchema) {
            this.catalogSchema = catalogSchema;
            this.entitySchema = entitySchema;
            this.parameters = new LinkedList<OpenApiEndpointParameter>();
        }

        @Nonnull
        public Builder method(@Nonnull PathItem.HttpMethod method) {
            this.method = method;
            return this;
        }

        @Nonnull
        public Builder path(@Nonnull UnaryOperator<OpenApiEndpoint.PathBuilder> pathBuilderFunction) {
            return this.path(false, pathBuilderFunction);
        }

        @Nonnull
        public Builder path(boolean localized, @Nonnull UnaryOperator<OpenApiEndpoint.PathBuilder> pathBuilderFunction) {
            OpenApiEndpoint.PathBuilder pathBuilder = OpenApiEndpoint.PathBuilder.newPath();
            if (localized) {
                pathBuilder.paramItem(OpenApiEndpointParameter.newPathParameter().name(EndpointHeaderDescriptor.LOCALIZED.name()).description(EndpointHeaderDescriptor.LOCALIZED.description()).type(OpenApiTypeReference.typeRefTo(CatalogDataApiRootDescriptor.LOCALE_ENUM.name())).build());
            }
            pathBuilder.staticItem(this.entitySchema.getName());
            pathBuilder = (OpenApiEndpoint.PathBuilder)pathBuilderFunction.apply(pathBuilder);
            this.localized = localized;
            this.path = pathBuilder.getPath();
            this.parameters.addAll(pathBuilder.getPathParameters());
            return this;
        }

        @Nonnull
        public Builder operationId(@Nonnull String operationId) {
            this.operationId = operationId;
            return this;
        }

        @Nonnull
        public Builder description(@Nonnull String description) {
            this.description = description;
            return this;
        }

        @Nonnull
        public Builder deprecationNotice(@Nullable String deprecationNotice) {
            this.deprecationNotice = deprecationNotice;
            return this;
        }

        @Nonnull
        public Builder queryParameter(@Nonnull OpenApiEndpointParameter queryParameter) {
            Assert.isPremiseValid((boolean)queryParameter.getLocation().equals((Object)OpenApiEndpointParameter.ParameterLocation.QUERY), () -> new OpenApiBuildingError("Only query parameters are supported here."));
            this.parameters.add(queryParameter);
            return this;
        }

        @Nonnull
        public Builder queryParameters(@Nonnull List<OpenApiEndpointParameter> queryParameters) {
            queryParameters.forEach(queryParameter -> Assert.isPremiseValid((boolean)queryParameter.getLocation().equals((Object)OpenApiEndpointParameter.ParameterLocation.QUERY), () -> new OpenApiBuildingError("Only query parameters are supported here.")));
            this.parameters.addAll(queryParameters);
            return this;
        }

        @Nonnull
        public Builder requestBody(@Nonnull OpenApiSimpleType requestBodyType) {
            this.requestBody = requestBodyType;
            return this;
        }

        @Nonnull
        public Builder successResponse(@Nonnull OpenApiSimpleType successResponseType) {
            this.successResponse = successResponseType;
            return this;
        }

        @Nonnull
        public Builder handler(@Nonnull Function<CollectionRestHandlingContext, RestEndpointHandler<CollectionRestHandlingContext>> handlerBuilder) {
            this.handlerBuilder = handlerBuilder;
            return this;
        }

        @Nonnull
        public OpenApiCollectionEndpoint build() {
            Assert.isPremiseValid((this.path != null ? 1 : 0) != 0, () -> new OpenApiBuildingError("Missing endpoint path."));
            Assert.isPremiseValid((this.method != null ? 1 : 0) != 0, () -> new OpenApiBuildingError("Endpoint `" + this.path + "` is missing method."));
            Assert.isPremiseValid((this.operationId != null && !this.operationId.isEmpty() ? 1 : 0) != 0, () -> new OpenApiBuildingError("Endpoint `" + this.path + "` is missing operationId."));
            Assert.isPremiseValid((this.description != null && !this.description.isEmpty() ? 1 : 0) != 0, () -> new OpenApiBuildingError("Endpoint `" + this.path + "` is missing description."));
            if (Set.of(PathItem.HttpMethod.POST, PathItem.HttpMethod.PUT, PathItem.HttpMethod.PATCH).contains(this.method)) {
                Assert.isPremiseValid((this.requestBody != null ? 1 : 0) != 0, () -> new OpenApiBuildingError("Endpoint `" + this.path + "` is missing request body."));
            } else if (Set.of(PathItem.HttpMethod.GET, PathItem.HttpMethod.HEAD, PathItem.HttpMethod.TRACE, PathItem.HttpMethod.OPTIONS).contains(this.method)) {
                Assert.isPremiseValid((this.requestBody == null ? 1 : 0) != 0, () -> new OpenApiBuildingError("Endpoint `" + this.path + "` doesn't support request body."));
            }
            if (Set.of(PathItem.HttpMethod.GET, PathItem.HttpMethod.POST, PathItem.HttpMethod.PUT, PathItem.HttpMethod.PATCH).contains(this.method)) {
                Assert.isPremiseValid((this.successResponse != null ? 1 : 0) != 0, () -> new OpenApiBuildingError("Endpoint `" + this.path + "` is missing success response."));
            }
            Assert.isPremiseValid((this.handlerBuilder != null ? 1 : 0) != 0, () -> new OpenApiBuildingError("Endpoint `" + this.path + "` is missing handler."));
            return new OpenApiCollectionEndpoint(this.catalogSchema, this.entitySchema, this.method, this.path, this.localized, this.operationId, this.description, this.deprecationNotice, this.parameters, this.requestBody, this.successResponse, this.handlerBuilder);
        }
    }
}

