/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.openApi;

import io.evitadb.externalApi.rest.api.openApi.OpenApiComplexType;
import io.evitadb.externalApi.rest.api.openApi.OpenApiSimpleType;
import io.evitadb.externalApi.rest.exception.OpenApiBuildingError;
import io.evitadb.utils.Assert;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OpenApiDictionary
implements OpenApiComplexType {
    @Nonnull
    private final String name;
    @Nullable
    private final String description;
    @Nullable
    private final String deprecationNotice;
    @Nonnull
    private final OpenApiSimpleType valueType;

    @Nonnull
    public static Builder newDictionary() {
        return new Builder();
    }

    @Nonnull
    public static Builder newDictionary(@Nonnull OpenApiDictionary existingDictionary) {
        return new Builder(existingDictionary);
    }

    @Nonnull
    public Schema<Object> toSchema() {
        ObjectSchema schema = new ObjectSchema();
        schema.additionalProperties(this.valueType.toSchema());
        schema.name(this.name);
        schema.description(this.description);
        if (this.deprecationNotice != null) {
            schema.deprecated(Boolean.valueOf(true));
        }
        return schema;
    }

    private OpenApiDictionary(@Nonnull String name, @Nullable String description, @Nullable String deprecationNotice, @Nonnull OpenApiSimpleType valueType) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (valueType == null) {
            throw new NullPointerException("valueType is marked non-null but is null");
        }
        this.name = name;
        this.description = description;
        this.deprecationNotice = deprecationNotice;
        this.valueType = valueType;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public String getDeprecationNotice() {
        return this.deprecationNotice;
    }

    @Nonnull
    public OpenApiSimpleType getValueType() {
        return this.valueType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenApiDictionary)) {
            return false;
        }
        OpenApiDictionary other = (OpenApiDictionary)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$deprecationNotice = this.getDeprecationNotice();
        String other$deprecationNotice = other.getDeprecationNotice();
        if (this$deprecationNotice == null ? other$deprecationNotice != null : !this$deprecationNotice.equals(other$deprecationNotice)) {
            return false;
        }
        OpenApiSimpleType this$valueType = this.getValueType();
        OpenApiSimpleType other$valueType = other.getValueType();
        return !(this$valueType == null ? other$valueType != null : !this$valueType.equals(other$valueType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OpenApiDictionary;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $deprecationNotice = this.getDeprecationNotice();
        result = result * 59 + ($deprecationNotice == null ? 43 : $deprecationNotice.hashCode());
        OpenApiSimpleType $valueType = this.getValueType();
        result = result * 59 + ($valueType == null ? 43 : $valueType.hashCode());
        return result;
    }

    public String toString() {
        return "OpenApiDictionary(name=" + this.getName() + ", description=" + this.getDescription() + ", deprecationNotice=" + this.getDeprecationNotice() + ", valueType=" + this.getValueType() + ")";
    }

    public static class Builder {
        @Nullable
        private String name;
        @Nullable
        private String description;
        @Nullable
        private String deprecationNotice;
        @Nullable
        private OpenApiSimpleType valueType;

        private Builder() {
        }

        private Builder(@Nonnull OpenApiDictionary existingObject) {
            this(existingObject.name, existingObject.description, existingObject.deprecationNotice, existingObject.valueType);
        }

        @Nonnull
        public Builder name(@Nonnull String name) {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        @Nonnull
        public Builder deprecationNotice(@Nullable String deprecationNotice) {
            this.deprecationNotice = deprecationNotice;
            return this;
        }

        @Nonnull
        public Builder valueType(@Nonnull OpenApiSimpleType valueType) {
            this.valueType = valueType;
            return this;
        }

        @Nonnull
        public OpenApiDictionary build() {
            Assert.isPremiseValid((this.name != null && !this.name.isEmpty() ? 1 : 0) != 0, () -> new OpenApiBuildingError("Missing object name."));
            Assert.isPremiseValid((this.valueType != null ? 1 : 0) != 0, () -> new OpenApiBuildingError("Missing value type."));
            return new OpenApiDictionary(this.name, this.description, this.deprecationNotice, this.valueType);
        }

        private Builder(@Nullable String name, @Nullable String description, @Nullable String deprecationNotice, @Nullable OpenApiSimpleType valueType) {
            this.name = name;
            this.description = description;
            this.deprecationNotice = deprecationNotice;
            this.valueType = valueType;
        }
    }
}

