/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.openApi;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.evitadb.core.Evita;
import io.evitadb.externalApi.rest.api.model.ErrorDescriptor;
import io.evitadb.externalApi.rest.api.openApi.OpenApiEndpointParameter;
import io.evitadb.externalApi.rest.api.openApi.OpenApiNonNull;
import io.evitadb.externalApi.rest.api.openApi.OpenApiSimpleType;
import io.evitadb.externalApi.rest.api.openApi.OpenApiTypeReference;
import io.evitadb.externalApi.rest.exception.OpenApiBuildingError;
import io.evitadb.externalApi.rest.io.RestEndpointHandler;
import io.evitadb.externalApi.rest.io.RestHandlingContext;
import io.evitadb.externalApi.utils.UriPath;
import io.evitadb.utils.Assert;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class OpenApiEndpoint<HC extends RestHandlingContext> {
    private static final String STATUS_CODE_OK = String.valueOf(200);
    private static final String STATUS_CODE_NO_CONTENT = String.valueOf(204);
    private static final String STATUS_CODE_INTERNAL_SERVER_ERROR = String.valueOf(500);
    private static final String STATUS_CODE_METHOD_NOT_ALLOWED = String.valueOf(405);
    private static final String STATUS_CODE_NOT_FOUND = String.valueOf(404);
    private static final String STATUS_CODE_NOT_ACCEPTABLE = String.valueOf(406);
    private static final String STATUS_CODE_UNSUPPORTED_MEDIA_TYPE = String.valueOf(415);
    private static final String STATUS_CODE_BAD_REQUEST = String.valueOf(400);
    @Nonnull
    protected final PathItem.HttpMethod method;
    @Nonnull
    protected final UriPath path;
    protected final boolean localized;
    @Nonnull
    protected final String operationId;
    @Nonnull
    protected final String description;
    @Nullable
    protected final String deprecationNotice;
    @Nonnull
    protected final List<OpenApiEndpointParameter> parameters;
    @Nullable
    protected final OpenApiSimpleType requestBody;
    @Nullable
    protected final OpenApiSimpleType successResponse;
    @Nonnull
    protected final Function<HC, RestEndpointHandler<HC>> handlerBuilder;

    @Nonnull
    public abstract RestEndpointHandler<HC> toHandler(@Nonnull ObjectMapper var1, @Nonnull Evita var2, @Nonnull OpenAPI var3, @Nonnull Map<String, Class<? extends Enum<?>>> var4);

    @Nonnull
    public Operation toOperation() {
        Operation operation = new Operation();
        operation.operationId(this.operationId);
        operation.description(this.description);
        if (this.deprecationNotice != null) {
            operation.deprecated(Boolean.valueOf(true));
        }
        operation.parameters(this.parameters.stream().map(OpenApiEndpointParameter::toParameter).toList());
        if (this.requestBody != null) {
            operation.requestBody(this.createRequestBody(this.requestBody));
        }
        ApiResponses responses = new ApiResponses();
        if (this.successResponse != null) {
            responses.addApiResponse(STATUS_CODE_OK, this.createResponse("Request was successful.", this.successResponse));
        } else {
            responses.addApiResponse(STATUS_CODE_NO_CONTENT, this.createResponse("Request was successful.", null));
        }
        if (!(this.successResponse instanceof OpenApiNonNull)) {
            responses.addApiResponse(STATUS_CODE_NOT_FOUND, this.createErrorResponse("Resource not found."));
        }
        responses.addApiResponse(STATUS_CODE_INTERNAL_SERVER_ERROR, this.createErrorResponse("Unexpected internal error."));
        responses.addApiResponse(STATUS_CODE_METHOD_NOT_ALLOWED, this.createErrorResponse("Used method is not allowed at this endpoint."));
        responses.addApiResponse(STATUS_CODE_NOT_ACCEPTABLE, this.createErrorResponse("Cannot produce a response matching the list of acceptable values."));
        responses.addApiResponse(STATUS_CODE_UNSUPPORTED_MEDIA_TYPE, this.createErrorResponse("The media format of the requested data is not supported by the server."));
        responses.addApiResponse(STATUS_CODE_BAD_REQUEST, this.createErrorResponse("The server cannot or will not process the request due to malformed request syntax."));
        operation.responses(responses);
        return operation;
    }

    @Nonnull
    protected RequestBody createRequestBody(@Nonnull OpenApiSimpleType type) {
        return new RequestBody().content(new Content().addMediaType("application/json", new MediaType().schema(type.toSchema())));
    }

    @Nonnull
    protected ApiResponse createResponse(@Nonnull String description, @Nullable OpenApiSimpleType type) {
        ApiResponse response = new ApiResponse().description(description);
        if (type != null) {
            response.content(new Content().addMediaType("application/json", new MediaType().schema(type.toSchema())));
        }
        return response;
    }

    @Nonnull
    protected ApiResponse createErrorResponse(@Nonnull String description) {
        return this.createResponse(description, OpenApiTypeReference.typeRefTo(ErrorDescriptor.THIS.name()));
    }

    protected OpenApiEndpoint(@Nonnull PathItem.HttpMethod method, @Nonnull UriPath path, boolean localized, @Nonnull String operationId, @Nonnull String description, @Nullable String deprecationNotice, @Nonnull List<OpenApiEndpointParameter> parameters, @Nullable OpenApiSimpleType requestBody, @Nullable OpenApiSimpleType successResponse, @Nonnull Function<HC, RestEndpointHandler<HC>> handlerBuilder) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (operationId == null) {
            throw new NullPointerException("operationId is marked non-null but is null");
        }
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        if (handlerBuilder == null) {
            throw new NullPointerException("handlerBuilder is marked non-null but is null");
        }
        this.method = method;
        this.path = path;
        this.localized = localized;
        this.operationId = operationId;
        this.description = description;
        this.deprecationNotice = deprecationNotice;
        this.parameters = parameters;
        this.requestBody = requestBody;
        this.successResponse = successResponse;
        this.handlerBuilder = handlerBuilder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenApiEndpoint)) {
            return false;
        }
        OpenApiEndpoint other = (OpenApiEndpoint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.localized != other.localized) {
            return false;
        }
        PathItem.HttpMethod this$method = this.getMethod();
        PathItem.HttpMethod other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        UriPath this$path = this.getPath();
        UriPath other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$operationId = this.operationId;
        String other$operationId = other.operationId;
        if (this$operationId == null ? other$operationId != null : !this$operationId.equals(other$operationId)) {
            return false;
        }
        String this$description = this.description;
        String other$description = other.description;
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$deprecationNotice = this.deprecationNotice;
        String other$deprecationNotice = other.deprecationNotice;
        if (this$deprecationNotice == null ? other$deprecationNotice != null : !this$deprecationNotice.equals(other$deprecationNotice)) {
            return false;
        }
        List<OpenApiEndpointParameter> this$parameters = this.parameters;
        List<OpenApiEndpointParameter> other$parameters = other.parameters;
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        OpenApiSimpleType this$requestBody = this.requestBody;
        OpenApiSimpleType other$requestBody = other.requestBody;
        if (this$requestBody == null ? other$requestBody != null : !this$requestBody.equals(other$requestBody)) {
            return false;
        }
        OpenApiSimpleType this$successResponse = this.successResponse;
        OpenApiSimpleType other$successResponse = other.successResponse;
        if (this$successResponse == null ? other$successResponse != null : !this$successResponse.equals(other$successResponse)) {
            return false;
        }
        Function<HC, RestEndpointHandler<HC>> this$handlerBuilder = this.handlerBuilder;
        Function<HC, RestEndpointHandler<HC>> other$handlerBuilder = other.handlerBuilder;
        return !(this$handlerBuilder == null ? other$handlerBuilder != null : !this$handlerBuilder.equals(other$handlerBuilder));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OpenApiEndpoint;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.localized ? 79 : 97);
        PathItem.HttpMethod $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        UriPath $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $operationId = this.operationId;
        result = result * 59 + ($operationId == null ? 43 : $operationId.hashCode());
        String $description = this.description;
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $deprecationNotice = this.deprecationNotice;
        result = result * 59 + ($deprecationNotice == null ? 43 : $deprecationNotice.hashCode());
        List<OpenApiEndpointParameter> $parameters = this.parameters;
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        OpenApiSimpleType $requestBody = this.requestBody;
        result = result * 59 + ($requestBody == null ? 43 : $requestBody.hashCode());
        OpenApiSimpleType $successResponse = this.successResponse;
        result = result * 59 + ($successResponse == null ? 43 : $successResponse.hashCode());
        Function<HC, RestEndpointHandler<HC>> $handlerBuilder = this.handlerBuilder;
        result = result * 59 + ($handlerBuilder == null ? 43 : $handlerBuilder.hashCode());
        return result;
    }

    public String toString() {
        return "OpenApiEndpoint(method=" + this.getMethod() + ", path=" + this.getPath() + ", localized=" + this.localized + ", operationId=" + this.operationId + ", description=" + this.description + ", deprecationNotice=" + this.deprecationNotice + ", parameters=" + this.parameters + ", requestBody=" + this.requestBody + ", successResponse=" + this.successResponse + ", handlerBuilder=" + this.handlerBuilder + ")";
    }

    @Nonnull
    public PathItem.HttpMethod getMethod() {
        return this.method;
    }

    @Nonnull
    public UriPath getPath() {
        return this.path;
    }

    public static class PathBuilder {
        @Nonnull
        private UriPath.Builder pathBuilder = UriPath.builder();
        private final List<OpenApiEndpointParameter> pathParameters = new LinkedList<OpenApiEndpointParameter>();

        @Nonnull
        public UriPath getPath() {
            return this.pathBuilder.build();
        }

        @Nonnull
        public static PathBuilder newPath() {
            return new PathBuilder();
        }

        @Nonnull
        public PathBuilder staticItem(@Nullable String staticItem) {
            if (staticItem != null && !staticItem.isEmpty()) {
                this.pathBuilder.part(staticItem);
            }
            return this;
        }

        @Nonnull
        public PathBuilder paramItem(@Nullable OpenApiEndpointParameter paramItem) {
            if (paramItem != null) {
                Assert.isPremiseValid((boolean)paramItem.getLocation().equals((Object)OpenApiEndpointParameter.ParameterLocation.PATH), () -> new OpenApiBuildingError("Path only supports path parameters."));
                this.pathBuilder.part("{" + paramItem.getName() + "}");
                this.pathParameters.add(paramItem);
            }
            return this;
        }

        @Nonnull
        public PathBuilder paramItem(@Nullable OpenApiEndpointParameter.Builder paramItemBuilder) {
            if (paramItemBuilder != null) {
                return this.paramItem(paramItemBuilder.build());
            }
            return this;
        }

        private PathBuilder() {
        }

        public List<OpenApiEndpointParameter> getPathParameters() {
            return this.pathParameters;
        }
    }
}

