/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.openApi;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.evitadb.externalApi.rest.api.openApi.OpenApiNonNull;
import io.evitadb.externalApi.rest.api.openApi.OpenApiSimpleType;
import io.evitadb.externalApi.rest.api.resolver.serializer.ObjectJsonSerializer;
import io.evitadb.externalApi.rest.exception.OpenApiBuildingError;
import io.evitadb.utils.Assert;
import io.swagger.v3.oas.models.parameters.Parameter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OpenApiEndpointParameter {
    private static final ObjectJsonSerializer DEFAULT_VALUE_SERIALIZER = new ObjectJsonSerializer(new ObjectMapper());
    @Nonnull
    private final ParameterLocation location;
    @Nonnull
    private final String name;
    @Nullable
    private final String description;
    @Nullable
    private final String deprecationNotice;
    @Nonnull
    private final OpenApiSimpleType type;
    @Nullable
    private final Object defaultValue;

    @Nonnull
    public static Builder newPathParameter() {
        return new Builder(ParameterLocation.PATH);
    }

    @Nonnull
    public static Builder newQueryParameter() {
        return new Builder(ParameterLocation.QUERY);
    }

    @Nonnull
    public Parameter toParameter() {
        Parameter parameter = new Parameter();
        parameter.in(this.location.getLocation());
        parameter.name(this.name);
        parameter.description(this.description);
        if (this.deprecationNotice != null) {
            parameter.deprecated(Boolean.valueOf(true));
        }
        if (this.type instanceof OpenApiNonNull) {
            parameter.required(Boolean.valueOf(true));
        }
        parameter.schema(this.type.toSchema());
        if (this.defaultValue != null) {
            parameter.getSchema().setDefault((Object)DEFAULT_VALUE_SERIALIZER.serializeObject(this.defaultValue));
        }
        return parameter;
    }

    private OpenApiEndpointParameter(@Nonnull ParameterLocation location, @Nonnull String name, @Nullable String description, @Nullable String deprecationNotice, @Nonnull OpenApiSimpleType type, @Nullable Object defaultValue) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.location = location;
        this.name = name;
        this.description = description;
        this.deprecationNotice = deprecationNotice;
        this.type = type;
        this.defaultValue = defaultValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenApiEndpointParameter)) {
            return false;
        }
        OpenApiEndpointParameter other = (OpenApiEndpointParameter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ParameterLocation this$location = this.getLocation();
        ParameterLocation other$location = other.getLocation();
        if (this$location == null ? other$location != null : !((Object)((Object)this$location)).equals((Object)other$location)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.description;
        String other$description = other.description;
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$deprecationNotice = this.deprecationNotice;
        String other$deprecationNotice = other.deprecationNotice;
        if (this$deprecationNotice == null ? other$deprecationNotice != null : !this$deprecationNotice.equals(other$deprecationNotice)) {
            return false;
        }
        OpenApiSimpleType this$type = this.type;
        OpenApiSimpleType other$type = other.type;
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Object this$defaultValue = this.defaultValue;
        Object other$defaultValue = other.defaultValue;
        return !(this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OpenApiEndpointParameter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ParameterLocation $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : ((Object)((Object)$location)).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.description;
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $deprecationNotice = this.deprecationNotice;
        result = result * 59 + ($deprecationNotice == null ? 43 : $deprecationNotice.hashCode());
        OpenApiSimpleType $type = this.type;
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Object $defaultValue = this.defaultValue;
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        return result;
    }

    public String toString() {
        return "OpenApiEndpointParameter(location=" + this.getLocation() + ", name=" + this.getName() + ", description=" + this.description + ", deprecationNotice=" + this.deprecationNotice + ", type=" + this.type + ", defaultValue=" + this.defaultValue + ")";
    }

    @Nonnull
    public ParameterLocation getLocation() {
        return this.location;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public static class Builder {
        @Nonnull
        private final ParameterLocation location;
        @Nullable
        private String name;
        @Nullable
        private String description;
        @Nullable
        private String deprecationNotice;
        @Nullable
        private OpenApiSimpleType type;
        @Nullable
        private Object defaultValue;

        public Builder(@Nonnull ParameterLocation location) {
            this.location = location;
        }

        @Nonnull
        public Builder name(@Nonnull String name) {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        @Nonnull
        public Builder deprecationNotice(@Nonnull String deprecationNotice) {
            this.deprecationNotice = deprecationNotice;
            return this;
        }

        @Nonnull
        public Builder type(@Nonnull OpenApiSimpleType type) {
            this.type = type;
            return this;
        }

        @Nonnull
        public Builder defaultValue(@Nonnull Object defaultValue) {
            Assert.isPremiseValid((this.location == ParameterLocation.QUERY ? 1 : 0) != 0, () -> new OpenApiBuildingError("Default value is supported only for query parameters."));
            this.defaultValue = defaultValue;
            return this;
        }

        @Nonnull
        public OpenApiEndpointParameter build() {
            Assert.isPremiseValid((this.name != null && !this.name.isEmpty() ? 1 : 0) != 0, () -> new OpenApiBuildingError("Missing parameter name."));
            Assert.isPremiseValid((this.type != null ? 1 : 0) != 0, () -> new OpenApiBuildingError("Parameter `" + this.name + "` is missing type."));
            return new OpenApiEndpointParameter(this.location, this.name, this.description, this.deprecationNotice, this.type, this.defaultValue);
        }
    }

    public static enum ParameterLocation {
        PATH("path"),
        QUERY("query");

        private final String location;

        private ParameterLocation(String location) {
            this.location = location;
        }

        public String getLocation() {
            return this.location;
        }
    }
}

