/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.openApi;

import io.evitadb.externalApi.rest.api.openApi.OpenApiComplexType;
import io.evitadb.externalApi.rest.exception.OpenApiBuildingError;
import io.evitadb.utils.Assert;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OpenApiEnum
implements OpenApiComplexType {
    @Nullable
    private final Class<? extends Enum<?>> enumTemplate;
    @Nonnull
    private final String name;
    @Nullable
    private final String description;
    @Nullable
    private final String deprecationNotice;
    @Nullable
    private final String format;
    @Nonnull
    private final List<String> items;

    @Nonnull
    public static OpenApiEnum enumFrom(@Nonnull Class<? extends Enum<?>> javaEnum) {
        return new OpenApiEnum(javaEnum, javaEnum.getSimpleName(), null, null, null, Arrays.stream(javaEnum.getEnumConstants()).map(Enum::name).toList());
    }

    @Nonnull
    public static Builder newEnum() {
        return new Builder();
    }

    @Nonnull
    public static Builder newEnum(@Nonnull OpenApiEnum existingEnum) {
        return new Builder(existingEnum);
    }

    @Override
    @Nonnull
    public Schema<?> toSchema() {
        StringSchema schema = new StringSchema();
        schema.format(this.format);
        schema.name(this.name);
        schema.description(this.description);
        if (this.deprecationNotice != null) {
            schema.deprecated(Boolean.valueOf(true));
        }
        this.items.forEach(arg_0 -> ((Schema)schema).addEnumItemObject(arg_0));
        schema.example((Object)this.items.get(0));
        return schema;
    }

    private OpenApiEnum(@Nullable Class<? extends Enum<?>> enumTemplate, @Nonnull String name, @Nullable String description, @Nullable String deprecationNotice, @Nullable String format, @Nonnull List<String> items) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (items == null) {
            throw new NullPointerException("items is marked non-null but is null");
        }
        this.enumTemplate = enumTemplate;
        this.name = name;
        this.description = description;
        this.deprecationNotice = deprecationNotice;
        this.format = format;
        this.items = items;
    }

    @Nullable
    public Class<? extends Enum<?>> getEnumTemplate() {
        return this.enumTemplate;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public String getDeprecationNotice() {
        return this.deprecationNotice;
    }

    @Nullable
    public String getFormat() {
        return this.format;
    }

    @Nonnull
    public List<String> getItems() {
        return this.items;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenApiEnum)) {
            return false;
        }
        OpenApiEnum other = (OpenApiEnum)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Class<Enum<?>> this$enumTemplate = this.getEnumTemplate();
        Class<? extends Enum<?>> other$enumTemplate = other.getEnumTemplate();
        if (this$enumTemplate == null ? other$enumTemplate != null : !this$enumTemplate.equals(other$enumTemplate)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$deprecationNotice = this.getDeprecationNotice();
        String other$deprecationNotice = other.getDeprecationNotice();
        if (this$deprecationNotice == null ? other$deprecationNotice != null : !this$deprecationNotice.equals(other$deprecationNotice)) {
            return false;
        }
        String this$format = this.getFormat();
        String other$format = other.getFormat();
        if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
            return false;
        }
        List<String> this$items = this.getItems();
        List<String> other$items = other.getItems();
        return !(this$items == null ? other$items != null : !((Object)this$items).equals(other$items));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OpenApiEnum;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<Enum<?>> $enumTemplate = this.getEnumTemplate();
        result = result * 59 + ($enumTemplate == null ? 43 : $enumTemplate.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $deprecationNotice = this.getDeprecationNotice();
        result = result * 59 + ($deprecationNotice == null ? 43 : $deprecationNotice.hashCode());
        String $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        List<String> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        return result;
    }

    public String toString() {
        return "OpenApiEnum(enumTemplate=" + this.getEnumTemplate() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", deprecationNotice=" + this.getDeprecationNotice() + ", format=" + this.getFormat() + ", items=" + this.getItems() + ")";
    }

    public static class Builder {
        @Nullable
        private String name;
        @Nullable
        private String description;
        @Nullable
        private String deprecationNotice;
        @Nullable
        private String format;
        @Nonnull
        private final List<String> items;

        private Builder() {
            this.items = new LinkedList<String>();
        }

        private Builder(@Nonnull OpenApiEnum existingObject) {
            this(existingObject.name, existingObject.description, existingObject.deprecationNotice, existingObject.format, new LinkedList<String>(existingObject.items));
        }

        @Nonnull
        public Builder name(@Nonnull String name) {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        @Nonnull
        public Builder deprecationNotice(@Nullable String deprecationNotice) {
            this.deprecationNotice = deprecationNotice;
            return this;
        }

        @Nonnull
        public Builder format(@Nullable String format) {
            this.format = format;
            return this;
        }

        @Nonnull
        public Builder item(@Nonnull String item) {
            this.items.add(item);
            return this;
        }

        @Nonnull
        public OpenApiEnum build() {
            Assert.isPremiseValid((this.name != null && !this.name.isEmpty() ? 1 : 0) != 0, () -> new OpenApiBuildingError("Missing enum name."));
            Assert.isPremiseValid((!this.items.isEmpty() ? 1 : 0) != 0, () -> new OpenApiBuildingError("Enum `" + this.name + "` is missing items."));
            return new OpenApiEnum(null, this.name, this.description, this.deprecationNotice, this.format, this.items);
        }

        private Builder(@Nullable String name, @Nullable String description, @Nullable String deprecationNotice, @Nullable String format, @Nonnull List<String> items) {
            if (items == null) {
                throw new NullPointerException("items is marked non-null but is null");
            }
            this.name = name;
            this.description = description;
            this.deprecationNotice = deprecationNotice;
            this.format = format;
            this.items = items;
        }
    }
}

