/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.openApi;

import io.evitadb.externalApi.rest.api.openApi.OpenApiComplexType;
import io.evitadb.externalApi.rest.api.openApi.OpenApiProperty;
import io.evitadb.externalApi.rest.exception.OpenApiBuildingError;
import io.evitadb.utils.Assert;
import io.evitadb.utils.CollectionUtils;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OpenApiObject
implements OpenApiComplexType {
    @Nonnull
    private final String name;
    @Nullable
    private final String description;
    @Nullable
    private final String deprecationNotice;
    @Nonnull
    private final List<OpenApiProperty> properties;

    @Nonnull
    public static Builder newObject() {
        return new Builder();
    }

    @Nonnull
    public static Builder newObject(@Nonnull OpenApiObject existingObject) {
        return new Builder(existingObject);
    }

    @Nonnull
    public Schema<Object> toSchema() {
        ObjectSchema schema = new ObjectSchema();
        schema.name(this.name);
        schema.description(this.description);
        if (this.deprecationNotice != null) {
            schema.deprecated(Boolean.valueOf(true));
        }
        schema.setProperties(new LinkedHashMap(this.properties.size()));
        this.properties.forEach(arg_0 -> OpenApiObject.lambda$toSchema$0((Schema)schema, arg_0));
        return schema;
    }

    private OpenApiObject(@Nonnull String name, @Nullable String description, @Nullable String deprecationNotice, @Nonnull List<OpenApiProperty> properties) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.name = name;
        this.description = description;
        this.deprecationNotice = deprecationNotice;
        this.properties = properties;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public String getDeprecationNotice() {
        return this.deprecationNotice;
    }

    @Nonnull
    public List<OpenApiProperty> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenApiObject)) {
            return false;
        }
        OpenApiObject other = (OpenApiObject)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$deprecationNotice = this.getDeprecationNotice();
        String other$deprecationNotice = other.getDeprecationNotice();
        if (this$deprecationNotice == null ? other$deprecationNotice != null : !this$deprecationNotice.equals(other$deprecationNotice)) {
            return false;
        }
        List<OpenApiProperty> this$properties = this.getProperties();
        List<OpenApiProperty> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OpenApiObject;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $deprecationNotice = this.getDeprecationNotice();
        result = result * 59 + ($deprecationNotice == null ? 43 : $deprecationNotice.hashCode());
        List<OpenApiProperty> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "OpenApiObject(name=" + this.getName() + ", description=" + this.getDescription() + ", deprecationNotice=" + this.getDeprecationNotice() + ", properties=" + this.getProperties() + ")";
    }

    private static /* synthetic */ void lambda$toSchema$0(Schema schema, OpenApiProperty prop) {
        schema.addProperty(prop.getName(), prop.getSchema());
        if (prop.isNonNull()) {
            schema.addRequiredItem(prop.getName());
        }
    }

    public static class Builder {
        @Nullable
        private String name;
        @Nullable
        private String description;
        @Nullable
        private String deprecationNotice;
        @Nonnull
        private final Map<String, OpenApiProperty> properties;

        private Builder() {
            this.properties = CollectionUtils.createHashMap((int)20);
        }

        private Builder(@Nonnull OpenApiObject existingObject) {
            this(existingObject.name, existingObject.description, existingObject.deprecationNotice, new HashMap<String, OpenApiProperty>(existingObject.properties.stream().collect(Collectors.toMap(OpenApiProperty::getName, Function.identity()))));
        }

        @Nonnull
        public Builder name(@Nonnull String name) {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        @Nonnull
        public Builder deprecationNotice(@Nullable String deprecationNotice) {
            this.deprecationNotice = deprecationNotice;
            return this;
        }

        @Nonnull
        public Builder property(@Nonnull OpenApiProperty property) {
            this.properties.put(property.getName(), property);
            return this;
        }

        @Nonnull
        public Builder property(@Nonnull OpenApiProperty.Builder propertyBuilder) {
            return this.property(propertyBuilder.build());
        }

        @Nonnull
        public Builder property(@Nonnull UnaryOperator<OpenApiProperty.Builder> propertyBuilderFunction) {
            OpenApiProperty.Builder propertyBuilder = OpenApiProperty.newProperty();
            propertyBuilder = (OpenApiProperty.Builder)propertyBuilderFunction.apply(propertyBuilder);
            return this.property(propertyBuilder.build());
        }

        public boolean hasProperty(@Nonnull String name) {
            return this.properties.containsKey(name);
        }

        @Nonnull
        public OpenApiObject build() {
            Assert.isPremiseValid((this.name != null && !this.name.isEmpty() ? 1 : 0) != 0, () -> new OpenApiBuildingError("Missing object name."));
            return new OpenApiObject(this.name, this.description, this.deprecationNotice, new ArrayList<OpenApiProperty>(this.properties.values()));
        }

        private Builder(@Nullable String name, @Nullable String description, @Nullable String deprecationNotice, @Nonnull Map<String, OpenApiProperty> properties) {
            if (properties == null) {
                throw new NullPointerException("properties is marked non-null but is null");
            }
            this.name = name;
            this.description = description;
            this.deprecationNotice = deprecationNotice;
            this.properties = properties;
        }
    }
}

