/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.openApi;

import io.evitadb.externalApi.rest.api.openApi.OpenApiArray;
import io.evitadb.externalApi.rest.api.openApi.OpenApiNonNull;
import io.evitadb.externalApi.rest.api.openApi.OpenApiScalar;
import io.evitadb.externalApi.rest.api.openApi.OpenApiSimpleType;
import io.evitadb.externalApi.rest.api.openApi.OpenApiTypeReference;
import io.evitadb.externalApi.rest.exception.OpenApiBuildingError;
import io.evitadb.utils.Assert;
import io.swagger.v3.oas.models.media.Schema;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OpenApiProperty {
    @Nonnull
    private final String name;
    @Nullable
    private final String description;
    @Nullable
    private final String deprecationNotice;
    @Nonnull
    private final OpenApiSimpleType type;

    @Nonnull
    public static Builder newProperty() {
        return new Builder();
    }

    @Nonnull
    public static Builder newProperty(@Nonnull OpenApiProperty existingProperty) {
        return new Builder(existingProperty);
    }

    public boolean isNonNull() {
        return this.type instanceof OpenApiNonNull;
    }

    @Nonnull
    public Schema<?> getSchema() {
        return this.toSchema(this.type);
    }

    @Nonnull
    private Schema<?> toSchema(@Nonnull OpenApiSimpleType type) {
        Schema schema = new Schema();
        schema.name(this.name);
        if (type instanceof OpenApiScalar) {
            OpenApiScalar scalarType = (OpenApiScalar)type;
            Schema<?> scalarTypeSchema = scalarType.toSchema();
            schema.description(this.description);
            if (this.deprecationNotice != null) {
                schema.deprecated(Boolean.valueOf(true));
            }
            if (scalarTypeSchema.getType() != null) {
                schema.type(scalarTypeSchema.getType());
                schema.addType(scalarTypeSchema.getType());
            }
            if (!scalarType.isRange()) {
                schema.format(scalarTypeSchema.getFormat());
                schema.pattern(scalarTypeSchema.getPattern());
                if (scalarTypeSchema.getExample() != null) {
                    schema.example(scalarTypeSchema.getExample());
                }
                schema.minimum(scalarTypeSchema.getMinimum());
                schema.maximum(scalarTypeSchema.getMaximum());
                schema.minLength(scalarTypeSchema.getMinLength());
                schema.maxLength(scalarTypeSchema.getMaxLength());
                schema.oneOf(scalarTypeSchema.getOneOf());
                schema.anyOf(scalarTypeSchema.getAnyOf());
                schema.allOf(scalarTypeSchema.getAllOf());
            } else {
                schema.items(scalarTypeSchema.getItems());
                schema.minItems(scalarTypeSchema.getMinItems());
                schema.maxItems(scalarTypeSchema.getMaxItems());
            }
        } else if (type instanceof OpenApiTypeReference) {
            OpenApiTypeReference referenceType = (OpenApiTypeReference)type;
            schema.$ref(referenceType.toSchema().get$ref());
        } else if (type instanceof OpenApiArray) {
            OpenApiArray arrayType = (OpenApiArray)type;
            Schema<?> arrayTypeSchema = arrayType.toSchema();
            schema.description(this.description);
            if (this.deprecationNotice != null) {
                schema.deprecated(Boolean.valueOf(true));
            }
            schema.type(arrayTypeSchema.getType());
            schema.items(arrayTypeSchema.getItems());
            schema.minItems(arrayTypeSchema.getMinItems());
            schema.maxItems(arrayTypeSchema.getMaxItems());
        } else {
            if (type instanceof OpenApiNonNull) {
                OpenApiNonNull nonNullType = (OpenApiNonNull)type;
                return this.toSchema(nonNullType.getWrappedType());
            }
            throw new OpenApiBuildingError("Unknown type `" + this.type.getClass().getName() + "`.");
        }
        return schema;
    }

    private OpenApiProperty(@Nonnull String name, @Nullable String description, @Nullable String deprecationNotice, @Nonnull OpenApiSimpleType type) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.name = name;
        this.description = description;
        this.deprecationNotice = deprecationNotice;
        this.type = type;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public String getDeprecationNotice() {
        return this.deprecationNotice;
    }

    @Nonnull
    public OpenApiSimpleType getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenApiProperty)) {
            return false;
        }
        OpenApiProperty other = (OpenApiProperty)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$deprecationNotice = this.getDeprecationNotice();
        String other$deprecationNotice = other.getDeprecationNotice();
        if (this$deprecationNotice == null ? other$deprecationNotice != null : !this$deprecationNotice.equals(other$deprecationNotice)) {
            return false;
        }
        OpenApiSimpleType this$type = this.getType();
        OpenApiSimpleType other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OpenApiProperty;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $deprecationNotice = this.getDeprecationNotice();
        result = result * 59 + ($deprecationNotice == null ? 43 : $deprecationNotice.hashCode());
        OpenApiSimpleType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    public String toString() {
        return "OpenApiProperty(name=" + this.getName() + ", description=" + this.getDescription() + ", deprecationNotice=" + this.getDeprecationNotice() + ", type=" + this.getType() + ")";
    }

    public static class Builder {
        @Nullable
        private String name;
        @Nullable
        private String description;
        @Nullable
        private String deprecationNotice;
        @Nullable
        private OpenApiSimpleType type;

        private Builder(@Nonnull OpenApiProperty existingProperty) {
            this(existingProperty.name, existingProperty.description, existingProperty.deprecationNotice, existingProperty.type);
        }

        @Nonnull
        public Builder name(@Nonnull String name) {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        @Nonnull
        public Builder deprecationNotice(@Nonnull String deprecationNotice) {
            this.deprecationNotice = deprecationNotice;
            return this;
        }

        @Nonnull
        public Builder type(@Nonnull OpenApiSimpleType type) {
            this.type = type;
            return this;
        }

        @Nonnull
        public OpenApiProperty build() {
            Assert.isPremiseValid((this.name != null && !this.name.isEmpty() ? 1 : 0) != 0, () -> new OpenApiBuildingError("Missing property name."));
            Assert.isPremiseValid((this.type != null ? 1 : 0) != 0, () -> new OpenApiBuildingError("Property `" + this.name + "` is missing type."));
            return new OpenApiProperty(this.name, this.description, this.deprecationNotice, this.type);
        }

        private Builder(@Nullable String name, @Nullable String description, @Nullable String deprecationNotice, @Nullable OpenApiSimpleType type) {
            this.name = name;
            this.description = description;
            this.deprecationNotice = deprecationNotice;
            this.type = type;
        }

        private Builder() {
        }
    }
}

