/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.openApi;

import io.evitadb.externalApi.rest.api.openApi.SchemaUtils;
import io.evitadb.utils.CollectionUtils;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenApiReferenceValidator {
    private static final Logger log = LoggerFactory.getLogger(OpenApiReferenceValidator.class);
    private final HashSet<String> visitedSchemas;
    private final HashSet<String> missingSchemas;
    private final Map<String, Schema> schemas;

    public OpenApiReferenceValidator(@Nonnull OpenAPI openAPI) {
        this.schemas = openAPI.getComponents().getSchemas();
        this.visitedSchemas = CollectionUtils.createHashSet((int)100);
        this.missingSchemas = CollectionUtils.createHashSet((int)100);
    }

    public Set<String> validateSchemaReferences() {
        this.schemas.values().forEach(this::validateSchemaReferences);
        return this.missingSchemas;
    }

    private void validateSchemaReferences(@Nonnull Schema schema) {
        if (this.visitedSchemas.contains(schema.getName())) {
            return;
        }
        if (schema.getName() != null) {
            this.visitedSchemas.add(schema.getName());
        }
        if (schema instanceof ArraySchema) {
            ArraySchema arraySchema = (ArraySchema)schema;
            this.validateSchemaReferences(arraySchema.getItems());
        } else if (schema.get$ref() != null) {
            String schemaName = SchemaUtils.getSchemaNameFromReference(schema.get$ref());
            if (!this.schemas.containsKey(schemaName)) {
                this.missingSchemas.add(schemaName);
            }
        } else {
            if (schema.getProperties() != null) {
                Collection values = schema.getProperties().values();
                values.forEach(this::validateSchemaReferences);
            }
            if (schema.getAllOf() != null) {
                List allOf = schema.getAllOf();
                allOf.forEach(this::validateSchemaReferences);
            }
            if (schema.getAnyOf() != null) {
                List anyOf = schema.getAnyOf();
                anyOf.forEach(this::validateSchemaReferences);
            }
            if (schema.getOneOf() != null) {
                List oneOf = schema.getOneOf();
                oneOf.forEach(this::validateSchemaReferences);
            }
        }
    }

    public HashSet<String> getMissingSchemas() {
        return this.missingSchemas;
    }
}

