/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.openApi;

import io.evitadb.dataType.BigDecimalNumberRange;
import io.evitadb.dataType.ByteNumberRange;
import io.evitadb.dataType.ComplexDataObject;
import io.evitadb.dataType.DateTimeRange;
import io.evitadb.dataType.EvitaDataTypes;
import io.evitadb.dataType.IntegerNumberRange;
import io.evitadb.dataType.LongNumberRange;
import io.evitadb.dataType.Predecessor;
import io.evitadb.dataType.Range;
import io.evitadb.dataType.ShortNumberRange;
import io.evitadb.externalApi.dataType.Any;
import io.evitadb.externalApi.dataType.GenericObject;
import io.evitadb.externalApi.rest.api.openApi.OpenApiSimpleType;
import io.evitadb.externalApi.rest.exception.OpenApiBuildingError;
import io.evitadb.utils.Assert;
import io.evitadb.utils.CollectionUtils;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Currency;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class OpenApiScalar
implements OpenApiSimpleType {
    @Nonnull
    private static final Map<Class<?>, Supplier<Schema<?>>> SCALAR_SCHEMA_MAPPINGS = CollectionUtils.createHashMap((int)32);
    @Nonnull
    private final Class<?> javaType;

    private OpenApiScalar(@Nonnull Class<?> javaType) {
        Assert.isPremiseValid((!javaType.isArray() ? 1 : 0) != 0, () -> new OpenApiBuildingError("OpenAPI scalar cannot be created from Java array `" + javaType.getName() + "`."));
        Assert.isPremiseValid((!javaType.isEnum() ? 1 : 0) != 0, () -> new OpenApiBuildingError("OpenAPI scalar cannot be created from Java enum `" + javaType.getName() + "`."));
        Assert.isPremiseValid((EvitaDataTypes.isSupportedType(javaType) || ComplexDataObject.class.isAssignableFrom(javaType) || Any.class.isAssignableFrom(javaType) || GenericObject.class.isAssignableFrom(javaType) ? 1 : 0) != 0, () -> new OpenApiBuildingError("OpenAPI scalar doesn't support type `" + javaType.getName() + "`."));
        this.javaType = javaType.isPrimitive() ? EvitaDataTypes.getWrappingPrimitiveClass(javaType) : javaType;
    }

    @Nonnull
    public static OpenApiScalar scalarFrom(@Nonnull Class<?> javaType) {
        return new OpenApiScalar(javaType);
    }

    public boolean isRange() {
        return Range.class.isAssignableFrom(this.javaType);
    }

    @Override
    @Nonnull
    public Schema<?> toSchema() {
        return SCALAR_SCHEMA_MAPPINGS.get(this.javaType).get();
    }

    @Nonnull
    private static Schema<?> createRangeOf(@Nonnull Schema<?> schema) {
        ArraySchema rangeObject = new ArraySchema();
        rangeObject.format("range");
        rangeObject.items(schema);
        rangeObject.minItems(Integer.valueOf(2));
        rangeObject.maxItems(Integer.valueOf(2));
        return rangeObject;
    }

    @Nonnull
    private static Schema<?> createShortSchema() {
        IntegerSchema shortSchema = new IntegerSchema();
        shortSchema.format("int16").example((Object)845);
        return shortSchema;
    }

    @Nonnull
    private static Schema<?> createLongSchema() {
        StringSchema longSchema = new StringSchema();
        longSchema.format("int64").example((Object)"685487");
        return longSchema;
    }

    @Nonnull
    private static Schema<?> createBigDecimalSchema() {
        StringSchema bigDecimalSchema = new StringSchema();
        bigDecimalSchema.pattern("d+([.]d+)?").format("decimal").example((Object)"6584.25");
        return bigDecimalSchema;
    }

    @Nonnull
    private static Schema<?> createLocaleSchema() {
        StringSchema localeSchema = new StringSchema();
        localeSchema.format("locale").example((Object)"cs-CZ");
        return localeSchema;
    }

    @Nonnull
    private static Schema<?> createGenericObjectSchema() {
        ObjectSchema objectSchema = new ObjectSchema();
        objectSchema.setAdditionalProperties((Object)true);
        return objectSchema;
    }

    @Nonnull
    private static Schema<?> createOffsetDateTimeSchema() {
        StringSchema dateTimeSchema = new StringSchema();
        dateTimeSchema.format("date-time").example((Object)"2022-09-27T13:28:27.357+02:00");
        return dateTimeSchema;
    }

    @Nonnull
    private static Schema<?> createLocalDateTimeSchema() {
        StringSchema dateTimeSchema = new StringSchema();
        dateTimeSchema.format("local-date-time").example((Object)"2022-09-27T13:28:27.357");
        return dateTimeSchema;
    }

    @Nonnull
    private static Schema<?> createLocalDateSchema() {
        StringSchema dateTimeSchema = new StringSchema();
        dateTimeSchema.format("date").example((Object)"2022-09-27");
        return dateTimeSchema;
    }

    @Nonnull
    private static Schema<?> createLocalTimeSchema() {
        StringSchema dateTimeSchema = new StringSchema();
        dateTimeSchema.format("local-time").example((Object)"13:28:27.357");
        return dateTimeSchema;
    }

    @Nonnull
    private static Schema<?> createCharacterSchema() {
        StringSchema characterSchema = new StringSchema();
        characterSchema.minLength(Integer.valueOf(1)).maxLength(Integer.valueOf(1)).format("char");
        return characterSchema;
    }

    @Nonnull
    private static Schema<?> createCurrencySchema() {
        StringSchema currencySchema = new StringSchema();
        currencySchema.format("iso-4217").example((Object)"CZK");
        return currencySchema;
    }

    @Nonnull
    private static Schema<?> createUuidSchema() {
        StringSchema uuidSchema = new StringSchema();
        uuidSchema.format("uuid").example((Object)"01081e6f-851f-46b1-9f8f-075b582b5d2e");
        return uuidSchema;
    }

    @Nonnull
    private static Schema<?> createPredecessorSchema() {
        IntegerSchema predecessorSchema = new IntegerSchema();
        predecessorSchema.format("int32").example((Object)"44872");
        return predecessorSchema;
    }

    @Nonnull
    private static Schema<?> createByteSchema() {
        IntegerSchema byteSchema = new IntegerSchema();
        byteSchema.format("int8").example((Object)6);
        return byteSchema;
    }

    @Nonnull
    private static Schema<?> createAnySchema() {
        Schema anySchema = new Schema();
        anySchema.addAnyOfItem((Schema)new StringSchema());
        anySchema.addAnyOfItem((Schema)new NumberSchema());
        anySchema.addAnyOfItem((Schema)new IntegerSchema());
        anySchema.addAnyOfItem((Schema)new BooleanSchema());
        ArraySchema arraySchema = new ArraySchema();
        arraySchema.setItems(new Schema());
        anySchema.addAnyOfItem((Schema)arraySchema);
        anySchema.addAnyOfItem((Schema)new ObjectSchema());
        return anySchema;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenApiScalar)) {
            return false;
        }
        OpenApiScalar other = (OpenApiScalar)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Class<?> this$javaType = this.javaType;
        Class<?> other$javaType = other.javaType;
        return !(this$javaType == null ? other$javaType != null : !this$javaType.equals(other$javaType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OpenApiScalar;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<?> $javaType = this.javaType;
        result = result * 59 + ($javaType == null ? 43 : $javaType.hashCode());
        return result;
    }

    public String toString() {
        return "OpenApiScalar(javaType=" + this.javaType + ")";
    }

    static {
        SCALAR_SCHEMA_MAPPINGS.put(String.class, StringSchema::new);
        SCALAR_SCHEMA_MAPPINGS.put(Byte.class, OpenApiScalar::createByteSchema);
        SCALAR_SCHEMA_MAPPINGS.put(Short.class, OpenApiScalar::createShortSchema);
        SCALAR_SCHEMA_MAPPINGS.put(Integer.class, IntegerSchema::new);
        SCALAR_SCHEMA_MAPPINGS.put(Long.class, OpenApiScalar::createLongSchema);
        SCALAR_SCHEMA_MAPPINGS.put(Boolean.class, BooleanSchema::new);
        SCALAR_SCHEMA_MAPPINGS.put(Character.class, OpenApiScalar::createCharacterSchema);
        SCALAR_SCHEMA_MAPPINGS.put(BigDecimal.class, OpenApiScalar::createBigDecimalSchema);
        SCALAR_SCHEMA_MAPPINGS.put(OffsetDateTime.class, OpenApiScalar::createOffsetDateTimeSchema);
        SCALAR_SCHEMA_MAPPINGS.put(LocalDateTime.class, OpenApiScalar::createLocalDateTimeSchema);
        SCALAR_SCHEMA_MAPPINGS.put(LocalDate.class, OpenApiScalar::createLocalDateSchema);
        SCALAR_SCHEMA_MAPPINGS.put(LocalTime.class, OpenApiScalar::createLocalTimeSchema);
        SCALAR_SCHEMA_MAPPINGS.put(DateTimeRange.class, () -> OpenApiScalar.createRangeOf(OpenApiScalar.createOffsetDateTimeSchema()));
        SCALAR_SCHEMA_MAPPINGS.put(BigDecimalNumberRange.class, () -> OpenApiScalar.createRangeOf(OpenApiScalar.createBigDecimalSchema()));
        SCALAR_SCHEMA_MAPPINGS.put(ByteNumberRange.class, () -> OpenApiScalar.createRangeOf(OpenApiScalar.createByteSchema()));
        SCALAR_SCHEMA_MAPPINGS.put(ShortNumberRange.class, () -> OpenApiScalar.createRangeOf(OpenApiScalar.createShortSchema()));
        SCALAR_SCHEMA_MAPPINGS.put(IntegerNumberRange.class, () -> OpenApiScalar.createRangeOf(new IntegerSchema()));
        SCALAR_SCHEMA_MAPPINGS.put(LongNumberRange.class, () -> OpenApiScalar.createRangeOf(OpenApiScalar.createLongSchema()));
        SCALAR_SCHEMA_MAPPINGS.put(ComplexDataObject.class, OpenApiScalar::createGenericObjectSchema);
        SCALAR_SCHEMA_MAPPINGS.put(Locale.class, OpenApiScalar::createLocaleSchema);
        SCALAR_SCHEMA_MAPPINGS.put(Currency.class, OpenApiScalar::createCurrencySchema);
        SCALAR_SCHEMA_MAPPINGS.put(UUID.class, OpenApiScalar::createUuidSchema);
        SCALAR_SCHEMA_MAPPINGS.put(Predecessor.class, OpenApiScalar::createPredecessorSchema);
        SCALAR_SCHEMA_MAPPINGS.put(Any.class, OpenApiScalar::createAnySchema);
        SCALAR_SCHEMA_MAPPINGS.put(GenericObject.class, OpenApiScalar::createGenericObjectSchema);
    }
}

