/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.openApi;

import io.evitadb.externalApi.rest.api.openApi.OpenApiComplexType;
import io.evitadb.externalApi.rest.api.openApi.OpenApiObjectUnionType;
import io.evitadb.externalApi.rest.api.openApi.OpenApiTypeReference;
import io.evitadb.externalApi.rest.exception.OpenApiBuildingError;
import io.evitadb.utils.Assert;
import io.swagger.v3.oas.models.media.Discriminator;
import io.swagger.v3.oas.models.media.Schema;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OpenApiUnion
implements OpenApiComplexType {
    @Nonnull
    private final String name;
    @Nullable
    private final String description;
    @Nullable
    private final String deprecationNotice;
    @Nonnull
    private final OpenApiObjectUnionType type;
    @Nullable
    private final String discriminator;
    @Nonnull
    private final List<OpenApiTypeReference> objects;

    @Nonnull
    public static Builder newUnion() {
        return new Builder();
    }

    @Nonnull
    public static Builder newUnion(@Nonnull OpenApiUnion existingUnion) {
        return new Builder(existingUnion);
    }

    @Nonnull
    public Schema<Object> toSchema() {
        Schema schema = new Schema();
        switch (this.type) {
            case ONE_OF: {
                this.objects.forEach(it -> schema.addOneOfItem(it.toSchema()));
                break;
            }
            case ANY_OF: {
                this.objects.forEach(it -> schema.addAnyOfItem(it.toSchema()));
                break;
            }
            case ALL_OF: {
                this.objects.forEach(it -> schema.addAllOfItem(it.toSchema()));
            }
        }
        if (this.discriminator != null) {
            schema.discriminator(new Discriminator().propertyName(this.discriminator));
        }
        schema.name(this.name);
        schema.description(this.description);
        if (this.deprecationNotice != null) {
            schema.deprecated(Boolean.valueOf(true));
        }
        return schema;
    }

    private OpenApiUnion(@Nonnull String name, @Nullable String description, @Nullable String deprecationNotice, @Nonnull OpenApiObjectUnionType type, @Nullable String discriminator, @Nonnull List<OpenApiTypeReference> objects) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (objects == null) {
            throw new NullPointerException("objects is marked non-null but is null");
        }
        this.name = name;
        this.description = description;
        this.deprecationNotice = deprecationNotice;
        this.type = type;
        this.discriminator = discriminator;
        this.objects = objects;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public String getDeprecationNotice() {
        return this.deprecationNotice;
    }

    @Nonnull
    public OpenApiObjectUnionType getType() {
        return this.type;
    }

    @Nullable
    public String getDiscriminator() {
        return this.discriminator;
    }

    @Nonnull
    public List<OpenApiTypeReference> getObjects() {
        return this.objects;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenApiUnion)) {
            return false;
        }
        OpenApiUnion other = (OpenApiUnion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$deprecationNotice = this.getDeprecationNotice();
        String other$deprecationNotice = other.getDeprecationNotice();
        if (this$deprecationNotice == null ? other$deprecationNotice != null : !this$deprecationNotice.equals(other$deprecationNotice)) {
            return false;
        }
        OpenApiObjectUnionType this$type = this.getType();
        OpenApiObjectUnionType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$discriminator = this.getDiscriminator();
        String other$discriminator = other.getDiscriminator();
        if (this$discriminator == null ? other$discriminator != null : !this$discriminator.equals(other$discriminator)) {
            return false;
        }
        List<OpenApiTypeReference> this$objects = this.getObjects();
        List<OpenApiTypeReference> other$objects = other.getObjects();
        return !(this$objects == null ? other$objects != null : !((Object)this$objects).equals(other$objects));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OpenApiUnion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $deprecationNotice = this.getDeprecationNotice();
        result = result * 59 + ($deprecationNotice == null ? 43 : $deprecationNotice.hashCode());
        OpenApiObjectUnionType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $discriminator = this.getDiscriminator();
        result = result * 59 + ($discriminator == null ? 43 : $discriminator.hashCode());
        List<OpenApiTypeReference> $objects = this.getObjects();
        result = result * 59 + ($objects == null ? 43 : ((Object)$objects).hashCode());
        return result;
    }

    public String toString() {
        return "OpenApiUnion(name=" + this.getName() + ", description=" + this.getDescription() + ", deprecationNotice=" + this.getDeprecationNotice() + ", type=" + this.getType() + ", discriminator=" + this.getDiscriminator() + ", objects=" + this.getObjects() + ")";
    }

    public static class Builder {
        @Nullable
        private String name;
        @Nullable
        private String description;
        @Nullable
        private String deprecationNotice;
        @Nonnull
        private OpenApiObjectUnionType type = OpenApiObjectUnionType.ONE_OF;
        @Nullable
        private String discriminator;
        @Nonnull
        private final List<OpenApiTypeReference> objects;

        private Builder() {
            this.objects = new LinkedList<OpenApiTypeReference>();
        }

        private Builder(@Nonnull OpenApiUnion existingObject) {
            this(existingObject.name, existingObject.description, existingObject.deprecationNotice, existingObject.type, existingObject.discriminator, existingObject.objects);
        }

        @Nonnull
        public Builder name(@Nonnull String name) {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        @Nonnull
        public Builder deprecationNotice(@Nullable String deprecationNotice) {
            this.deprecationNotice = deprecationNotice;
            return this;
        }

        @Nonnull
        public Builder type(@Nonnull OpenApiObjectUnionType unionType) {
            this.type = unionType;
            return this;
        }

        @Nonnull
        public Builder discriminator(@Nonnull String unionDiscriminator) {
            this.discriminator = unionDiscriminator;
            return this;
        }

        @Nonnull
        public Builder object(@Nonnull OpenApiTypeReference unionObject) {
            this.objects.add(unionObject);
            return this;
        }

        @Nonnull
        public OpenApiUnion build() {
            Assert.isPremiseValid((this.name != null && !this.name.isEmpty() ? 1 : 0) != 0, () -> new OpenApiBuildingError("Missing object name."));
            Assert.isPremiseValid((!this.objects.isEmpty() ? 1 : 0) != 0, () -> new OpenApiBuildingError("Missing union objects"));
            return new OpenApiUnion(this.name, this.description, this.deprecationNotice, this.type, this.discriminator, this.objects);
        }

        private Builder(@Nullable String name, @Nullable String description, @Nullable String deprecationNotice, @Nonnull OpenApiObjectUnionType type, @Nullable String discriminator, @Nonnull List<OpenApiTypeReference> objects) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            if (objects == null) {
                throw new NullPointerException("objects is marked non-null but is null");
            }
            this.name = name;
            this.description = description;
            this.deprecationNotice = deprecationNotice;
            this.type = type;
            this.discriminator = discriminator;
            this.objects = objects;
        }
    }
}

