/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.openApi;

import io.evitadb.externalApi.rest.api.catalog.dataApi.model.FetchEntityRequestDescriptor;
import io.evitadb.externalApi.rest.exception.RestInternalError;
import io.evitadb.externalApi.rest.exception.RestQueryResolvingInternalError;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SchemaUtils {
    public static final int MAX_TARGET_SCHEMA_SEARCH_NESTING_COUNT = 100;

    @Nonnull
    public static Schema getTargetSchema(@Nonnull Schema schema, @Nonnull OpenAPI openAPI) {
        String reference = schema.get$ref();
        if (reference != null) {
            return SchemaUtils.getTargetSchema((Schema)openAPI.getComponents().getSchemas().get(SchemaUtils.getSchemaNameFromReference(reference)), openAPI);
        }
        return schema;
    }

    @Nonnull
    public static Schema getTargetSchemaFromRefOrOneOf(@Nonnull Schema schema, @Nonnull OpenAPI openAPI) {
        return SchemaUtils.getTargetSchemaFromRefOrOneOf(schema, openAPI, 1);
    }

    @Nonnull
    private static Schema getTargetSchemaFromRefOrOneOf(@Nonnull Schema schema, @Nonnull OpenAPI openAPI, int nestingCount) {
        if (nestingCount > 100) {
            throw new RestInternalError("Max nesting count reached when getting target schema, which probably means that there's a cycle in schema reference structure and application is unable to find schema, which is not an reference. Currently processing schema name: " + schema, "Error when deserializing query.");
        }
        Schema targetSchema = null;
        if (schema.get$ref() != null) {
            targetSchema = SchemaUtils.getTargetSchemaFromRefOrOneOf((Schema)openAPI.getComponents().getSchemas().get(SchemaUtils.getSchemaNameFromReference(schema.get$ref())), openAPI, ++nestingCount);
        }
        if (schema.getOneOf() != null && !schema.getOneOf().isEmpty()) {
            if (targetSchema != null) {
                SchemaUtils.throwTargetSchemaAlreadyFound(schema);
            }
            targetSchema = SchemaUtils.getTargetSchemaFromRefOrOneOf(SchemaUtils.getFirstSchemaFromListWhenOnlyOneSchemaAllowed(schema, schema.getOneOf()), openAPI, ++nestingCount);
        }
        if (targetSchema != null) {
            return targetSchema;
        }
        return schema;
    }

    private static Schema getFirstSchemaFromListWhenOnlyOneSchemaAllowed(@Nonnull Schema parentSchema, @Nonnull List<Schema> schemas) {
        if (schemas.size() == 1) {
            return schemas.get(0);
        }
        throw new RestInternalError("Can't get schema from list, found more than one schema in list. Parent schema: " + parentSchema.getName(), "Error when parsing input data.");
    }

    private static void throwTargetSchemaAlreadyFound(@Nonnull Schema schema) {
        throw new RestInternalError("Can't get target schema from any inner location, schema found in more than one place. Schema: " + schema.getName(), "Error when parsing input data.");
    }

    @Nonnull
    public static Schema getSchemaFromFilterBy(@Nonnull OpenAPI openAPI, @Nonnull Operation operation, @Nonnull String propertyName) {
        return SchemaUtils.getSchemaFromOperationProperty(openAPI, operation, propertyName, FetchEntityRequestDescriptor.FILTER_BY.name());
    }

    @Nonnull
    public static Schema getSchemaFromOrderBy(@Nonnull OpenAPI openAPI, @Nonnull Operation operation, @Nonnull String propertyName) {
        return SchemaUtils.getSchemaFromOperationProperty(openAPI, operation, propertyName, FetchEntityRequestDescriptor.ORDER_BY.name());
    }

    @Nonnull
    public static Schema getSchemaFromRequire(@Nonnull OpenAPI openAPI, @Nonnull Operation operation, @Nonnull String propertyName) {
        return SchemaUtils.getSchemaFromOperationProperty(openAPI, operation, propertyName, FetchEntityRequestDescriptor.REQUIRE.name());
    }

    @Nonnull
    private static Schema getSchemaFromOperationProperty(@Nonnull OpenAPI openAPI, @Nonnull Operation operation, @Nonnull String propertyName, @Nonnull String rootPropertyName) {
        Schema rootSchema = (Schema)SchemaUtils.getTargetSchema(((MediaType)operation.getRequestBody().getContent().get((Object)"application/json")).getSchema(), openAPI).getProperties().get(rootPropertyName);
        if (rootSchema != null) {
            Schema targetSchema = SchemaUtils.getTargetSchemaFromRefOrOneOf(rootSchema, openAPI);
            Map properties = targetSchema instanceof ArraySchema || "array".equals(targetSchema.getType()) ? SchemaUtils.getTargetSchemaFromRefOrOneOf(targetSchema.getItems(), openAPI).getProperties() : targetSchema.getProperties();
            Optional<Schema> propertySchema = SchemaUtils.getSchemaFromPropertiesByPropertyName(openAPI, properties, new LinkedList<String>(), propertyName);
            if (propertySchema.isPresent()) {
                return propertySchema.get();
            }
            throw new RestQueryResolvingInternalError("Attribute wasn't found in Operation, unable to deserialize attribute: " + propertyName, "Unexpected error when deserializing attribute: " + propertyName);
        }
        throw new RestQueryResolvingInternalError("Root attribute wasn't found in Operation, unable to deserialize attribute: " + rootPropertyName, "Unexpected error when deserializing attribute: " + rootPropertyName);
    }

    @Nonnull
    private static Optional<Schema> getSchemaFromPropertiesByPropertyName(@Nonnull OpenAPI openAPI, @Nullable Map<String, Schema> properties, @Nonnull List<String> visitedReferences, @Nonnull String propertyName) {
        if (properties == null) {
            return Optional.empty();
        }
        Schema propertySchema = properties.get(propertyName);
        if (propertySchema != null) {
            return Optional.of(propertySchema);
        }
        for (Schema value : properties.values()) {
            Optional<Schema> oneOfSchema;
            Optional<Schema> foundAnyOfSchema;
            Optional<Schema> foundAllOfSchema;
            Schema schema;
            if (value instanceof ArraySchema) {
                ArraySchema arraySchema = (ArraySchema)value;
                schema = arraySchema.getItems();
            } else {
                schema = value;
            }
            if (SchemaUtils.isSchemaReferenceVisited(visitedReferences, schema)) continue;
            Optional<Schema> foundSchema = SchemaUtils.getSchemaFromPropertiesByPropertyName(openAPI, SchemaUtils.getTargetSchema(schema, openAPI).getProperties(), visitedReferences, propertyName);
            if (foundSchema.isPresent()) {
                return foundSchema;
            }
            if (schema.getAllOf() != null && (foundAllOfSchema = SchemaUtils.getSchemaFromSchemasByPropertyName(openAPI, visitedReferences, propertyName, schema.getAllOf())).isPresent()) {
                return foundAllOfSchema;
            }
            if (schema.getAnyOf() != null && (foundAnyOfSchema = SchemaUtils.getSchemaFromSchemasByPropertyName(openAPI, visitedReferences, propertyName, schema.getAnyOf())).isPresent()) {
                return foundAnyOfSchema;
            }
            if (schema.getOneOf() == null || !(oneOfSchema = SchemaUtils.getSchemaFromSchemasByPropertyName(openAPI, visitedReferences, propertyName, schema.getOneOf())).isPresent()) continue;
            return oneOfSchema;
        }
        return Optional.empty();
    }

    @Nonnull
    private static Optional<Schema> getSchemaFromSchemasByPropertyName(@Nonnull OpenAPI openAPI, @Nonnull List<String> visitedReferences, @Nonnull String propertyName, @Nonnull List<Schema> schemas) {
        for (Schema schema : schemas) {
            if (SchemaUtils.isSchemaReferenceVisited(visitedReferences, schema)) continue;
            return SchemaUtils.getSchemaFromPropertiesByPropertyName(openAPI, SchemaUtils.getTargetSchemaFromRefOrOneOf(schema, openAPI).getProperties(), visitedReferences, propertyName);
        }
        return Optional.empty();
    }

    private static boolean isSchemaReferenceVisited(@Nonnull List<String> visitedReferences, @Nonnull Schema schema) {
        if (schema.get$ref() != null) {
            if (visitedReferences.contains(schema.get$ref())) {
                return true;
            }
            visitedReferences.add(schema.get$ref());
        }
        return false;
    }

    @Nonnull
    public static String getSchemaNameFromReference(@Nonnull String reference) {
        return reference.substring(reference.lastIndexOf(47) + 1);
    }

    private SchemaUtils() {
    }
}

