/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.resolver.endpoint;

import io.evitadb.externalApi.http.EndpointResponse;
import io.evitadb.externalApi.http.SuccessEndpointResponse;
import io.evitadb.externalApi.rest.api.openApi.OpenApiWriter;
import io.evitadb.externalApi.rest.io.RestEndpointExchange;
import io.evitadb.externalApi.rest.io.RestEndpointHandler;
import io.evitadb.externalApi.rest.io.RestHandlingContext;
import io.evitadb.utils.CollectionUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnull;

public class OpenApiSpecificationHandler<C extends RestHandlingContext>
extends RestEndpointHandler<C> {
    public OpenApiSpecificationHandler(@Nonnull C restHandlingContext) {
        super(restHandlingContext);
    }

    @Nonnull
    protected EndpointResponse doHandleRequest(@Nonnull RestEndpointExchange exchange) {
        return new SuccessEndpointResponse((Object)this.restHandlingContext.getOpenApi());
    }

    @Nonnull
    public Set<String> getSupportedHttpMethods() {
        return Set.of("GET");
    }

    @Nonnull
    public LinkedHashSet<String> getSupportedResponseContentTypes() {
        LinkedHashSet mediaTypes = CollectionUtils.createLinkedHashSet((int)2);
        mediaTypes.add("application/json");
        mediaTypes.add("application/yaml");
        return mediaTypes;
    }

    protected void writeResult(@Nonnull RestEndpointExchange exchange, @Nonnull OutputStream outputStream, @Nonnull Object openApiSpecification) {
        block4: {
            String preferredResponseMediaType = exchange.preferredResponseContentType();
            try {
                if (preferredResponseMediaType.equals("application/yaml")) {
                    OpenApiWriter.toYaml(openApiSpecification, outputStream);
                    break block4;
                }
                if (preferredResponseMediaType.equals("application/json")) {
                    OpenApiWriter.toJson(openApiSpecification, outputStream);
                    break block4;
                }
                throw this.createInternalError("Should never happen!");
            }
            catch (IOException e) {
                throw this.createInternalError("Could not serialize OpenAPI specification: " + e.getMessage());
            }
        }
    }
}

