/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.resolver.serializer;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import io.evitadb.dataType.BigDecimalNumberRange;
import io.evitadb.dataType.ByteNumberRange;
import io.evitadb.dataType.DateTimeRange;
import io.evitadb.dataType.EvitaDataTypes;
import io.evitadb.dataType.IntegerNumberRange;
import io.evitadb.dataType.LongNumberRange;
import io.evitadb.dataType.Predecessor;
import io.evitadb.dataType.ShortNumberRange;
import io.evitadb.externalApi.rest.api.openApi.SchemaUtils;
import io.evitadb.externalApi.rest.exception.RestInternalError;
import io.evitadb.externalApi.rest.exception.RestInvalidArgumentException;
import io.evitadb.externalApi.rest.exception.RestQueryResolvingInternalError;
import io.evitadb.externalApi.rest.exception.RestTooManyValuesPresentException;
import io.evitadb.utils.Assert;
import io.evitadb.utils.CollectionUtils;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Currency;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DataDeserializer {
    private final OpenAPI openApi;
    private final Map<String, Class<? extends Enum<?>>> enumMapping;

    @Nullable
    public Object deserializeValue(@Nonnull Schema schema, @Nonnull String[] data) {
        if (data.length == 0) {
            Class<? extends Serializable> schemaClass = this.resolveDataClass(SchemaUtils.getTargetSchemaFromRefOrOneOf(schema.getItems(), this.openApi));
            return Array.newInstance(schemaClass, 0);
        }
        if ("array".equals(schema.getType())) {
            if ("range".equals(schema.getFormat())) {
                return this.deserializeRange(this.resolveDataClass(SchemaUtils.getTargetSchemaFromRefOrOneOf(schema.getItems(), this.openApi)), data, schema.getName());
            }
            return this.deserializeArray(schema, data);
        }
        if (data.length > 1) {
            throw new RestTooManyValuesPresentException("Expected one value of parameter " + schema.getName() + " but found: " + data.length);
        }
        return this.deserializeValue(schema, data[0]);
    }

    public Object deserializeValue(@Nonnull Schema<?> schema, @Nonnull JsonNode jsonNode) {
        if (jsonNode.isArray() && jsonNode.isEmpty() || jsonNode.asText() == null) {
            Class<? extends Serializable> schemaClass = this.resolveDataClass(SchemaUtils.getTargetSchemaFromRefOrOneOf(schema.getItems(), this.openApi));
            return Array.newInstance(schemaClass, 0);
        }
        if ("array".equals(schema.getType())) {
            if ("range".equals(schema.getFormat())) {
                return this.deserializeRange(this.resolveDataClass(SchemaUtils.getTargetSchemaFromRefOrOneOf(schema.getItems(), this.openApi)), jsonNode, schema.getName());
            }
            return this.deserializeArray(schema, this.getNodeValuesAsStringArray(jsonNode, schema.getName()));
        }
        return this.deserializeValue(schema, jsonNode.asText());
    }

    @Nullable
    public <T extends Serializable> T deserializeValue(@Nonnull Class<T> targetClass, @Nullable JsonNode value) {
        if (value == null || value.isNull()) {
            return null;
        }
        if (targetClass.isArray()) {
            if (value instanceof ArrayNode) {
                ArrayNode arrayNode = (ArrayNode)value;
                return (T)this.deserializeArray(targetClass.getComponentType(), arrayNode);
            }
            throw new RestInternalError("Target class is array but json node is not instance of ArrayNode. " + targetClass.getName());
        }
        if (Character.class.isAssignableFrom(targetClass) || Character.TYPE.isAssignableFrom(targetClass)) {
            return (T)Character.valueOf(value.asText().charAt(0));
        }
        if (Integer.class.isAssignableFrom(targetClass) || Integer.TYPE.isAssignableFrom(targetClass)) {
            return (T)Integer.valueOf(value.intValue());
        }
        if (Short.class.isAssignableFrom(targetClass) || Short.TYPE.isAssignableFrom(targetClass)) {
            return (T)Short.valueOf(value.shortValue());
        }
        if (Boolean.class.isAssignableFrom(targetClass) || Boolean.TYPE.isAssignableFrom(targetClass)) {
            return (T)Boolean.valueOf(value.booleanValue());
        }
        if (Byte.class.isAssignableFrom(targetClass) || Byte.TYPE.isAssignableFrom(targetClass)) {
            return (T)this.deserializeByteNumber(value);
        }
        if (String.class.isAssignableFrom(targetClass) || OffsetDateTime.class.isAssignableFrom(targetClass) || LocalDateTime.class.isAssignableFrom(targetClass) || LocalDate.class.isAssignableFrom(targetClass) || LocalTime.class.isAssignableFrom(targetClass) || Currency.class.isAssignableFrom(targetClass) || UUID.class.isAssignableFrom(targetClass) || BigDecimal.class.isAssignableFrom(targetClass) || Long.class.isAssignableFrom(targetClass) || Long.TYPE.isAssignableFrom(targetClass) || Locale.class.isAssignableFrom(targetClass)) {
            return (T)EvitaDataTypes.toTargetType((Serializable)((Object)value.asText()), targetClass);
        }
        if (Predecessor.class.isAssignableFrom(targetClass)) {
            return (T)new Predecessor(value.intValue());
        }
        if (targetClass.isEnum()) {
            return this.deserializeEnum(targetClass, value);
        }
        throw new RestInternalError("Deserialization of field of JavaType: " + targetClass.getSimpleName() + " is not implemented yet.");
    }

    @Nonnull
    public Object[] deserializeArray(@Nonnull Schema<?> schema, @Nonnull JsonNode jsonNode) {
        if (!"array".equals(schema.getType())) {
            throw new RestInvalidArgumentException("Can't deserialize value, schema type is not array. Name: " + schema.getName());
        }
        return this.deserializeArray(schema, this.getNodeValuesAsStringArray(jsonNode, schema.getName()));
    }

    @Nullable
    public Object deserializeTree(@Nonnull Schema<?> schema, @Nonnull JsonNode jsonNode) {
        if (jsonNode instanceof NullNode) {
            return null;
        }
        if (schema instanceof ArraySchema || "array".equals(schema.getType())) {
            Assert.isTrue((boolean)(jsonNode instanceof ArrayNode), () -> new RestInvalidArgumentException("Expected `ArrayNode` for schema `" + schema.getName() + "` but got `" + jsonNode.getClass().getSimpleName() + "`.", "Expected JSON array."));
            ArrayNode arrayNode = (ArrayNode)jsonNode;
            ArrayList<Object> objects = new ArrayList<Object>(arrayNode.size());
            for (JsonNode node : arrayNode) {
                objects.add(this.deserializeTree(SchemaUtils.getTargetSchemaFromRefOrOneOf(schema.getItems(), this.openApi), node));
            }
            return objects;
        }
        if (schema.getType() == null || "object".equals(schema.getType())) {
            Assert.isTrue((boolean)(jsonNode instanceof ObjectNode), () -> new RestInvalidArgumentException("Expected `ObjectNode` for schema `" + schema.getName() + "` but got `" + jsonNode.getClass().getSimpleName() + "`.", "Expected JSON object."));
            ObjectNode objectNode = (ObjectNode)jsonNode;
            HashMap dataMap = CollectionUtils.createHashMap((int)objectNode.size());
            Iterator namesIterator = objectNode.fieldNames();
            while (namesIterator.hasNext()) {
                String fieldName = (String)namesIterator.next();
                Schema propertySchema = (Schema)schema.getProperties().get(fieldName);
                if (propertySchema != null) {
                    Schema targetPropertySchema = SchemaUtils.getTargetSchemaFromRefOrOneOf(propertySchema, this.openApi);
                    dataMap.put(fieldName, this.deserializeTree(targetPropertySchema, objectNode.get(fieldName)));
                    continue;
                }
                throw new RestInvalidArgumentException("Invalid property name: " + fieldName);
            }
            return dataMap;
        }
        Assert.isTrue((boolean)(jsonNode instanceof ValueNode), () -> new RestInvalidArgumentException("Expected `ValueNode` for schema `" + schema.getName() + "` but got `" + jsonNode.getClass().getSimpleName() + "`.", "Expected JSON value."));
        return this.deserializeValue(schema, jsonNode);
    }

    @Nullable
    private Object deserializeValue(@Nonnull Schema schema, @Nonnull String data) {
        return this.deserializeValue(this.resolveDataClass(schema), data);
    }

    @Nullable
    private <T extends Serializable> T deserializeValue(@Nonnull Class<T> requestedType, @Nonnull String data) {
        if (requestedType.isEnum()) {
            return this.deserializeEnum(requestedType, data);
        }
        return (T)EvitaDataTypes.toTargetType((Serializable)((Object)data), requestedType);
    }

    @Nonnull
    private Object[] deserializeArray(@Nonnull Schema<?> schema, @Nonnull String[] data) {
        Class<? extends Serializable> arrayClass = this.resolveDataClass(SchemaUtils.getTargetSchemaFromRefOrOneOf(schema.getItems(), this.openApi));
        Object[] dataArray = (Object[])Array.newInstance(arrayClass, data.length);
        for (int i = 0; i < data.length; ++i) {
            dataArray[i] = this.deserializeValue(SchemaUtils.getTargetSchemaFromRefOrOneOf(schema.getItems(), this.openApi), data[i]);
        }
        return dataArray;
    }

    @Nonnull
    private <T extends Serializable> T[] deserializeArray(@Nonnull Class<T> targetClass, @Nonnull ArrayNode arrayNode) {
        Object deserialized = Array.newInstance(targetClass, arrayNode.size());
        for (int i = 0; i < arrayNode.size(); ++i) {
            Array.set(deserialized, i, this.deserializeValue(targetClass, arrayNode.get(i)));
        }
        return (Serializable[])deserialized;
    }

    @Nonnull
    private <T extends Serializable> T deserializeRange(@Nonnull Class<T> targetClass, @Nonnull JsonNode value, @Nonnull String attributeName) {
        ArrayNode values;
        if (value instanceof ArrayNode && (values = (ArrayNode)value).size() == 2) {
            if (OffsetDateTime.class.isAssignableFrom(targetClass)) {
                return this.deserializeRange(targetClass, this.deserializeValue(OffsetDateTime.class, values.get(0)), this.deserializeValue(OffsetDateTime.class, values.get(1)), attributeName);
            }
            if (BigDecimal.class.isAssignableFrom(targetClass)) {
                return this.deserializeRange(targetClass, this.deserializeValue(BigDecimal.class, values.get(0)), this.deserializeValue(BigDecimal.class, values.get(1)), attributeName);
            }
            if (Byte.class.isAssignableFrom(targetClass)) {
                return this.deserializeRange(targetClass, this.deserializeValue(Byte.class, values.get(0)), this.deserializeValue(Byte.class, values.get(1)), attributeName);
            }
            if (Short.class.isAssignableFrom(targetClass)) {
                return this.deserializeRange(targetClass, this.deserializeValue(Short.class, values.get(0)), this.deserializeValue(Short.class, values.get(1)), attributeName);
            }
            if (Integer.class.isAssignableFrom(targetClass)) {
                return this.deserializeRange(targetClass, this.deserializeValue(Integer.class, values.get(0)), this.deserializeValue(Integer.class, values.get(1)), attributeName);
            }
            if (Long.class.isAssignableFrom(targetClass)) {
                return this.deserializeRange(targetClass, this.deserializeValue(Long.class, values.get(0)), this.deserializeValue(Long.class, values.get(1)), attributeName);
            }
            throw new RestInternalError("Deserialization of range JavaType: " + targetClass.getSimpleName() + " is not implemented yet. Attribute: " + attributeName);
        }
        throw new RestInternalError("Array of two values is required for range data type. Attribute: " + attributeName);
    }

    @Nonnull
    private <T extends Serializable> T deserializeRange(@Nonnull Class<T> targetClass, @Nonnull String[] values, @Nonnull String attributeName) {
        if (values.length == 2) {
            if (OffsetDateTime.class.isAssignableFrom(targetClass)) {
                return this.deserializeRange(targetClass, this.deserializeValue(OffsetDateTime.class, values[0]), this.deserializeValue(OffsetDateTime.class, values[1]), attributeName);
            }
            if (BigDecimal.class.isAssignableFrom(targetClass)) {
                return this.deserializeRange(targetClass, this.deserializeValue(BigDecimal.class, values[0]), this.deserializeValue(BigDecimal.class, values[1]), attributeName);
            }
            if (Byte.class.isAssignableFrom(targetClass)) {
                return this.deserializeRange(targetClass, this.deserializeValue(Byte.class, values[0]), this.deserializeValue(Byte.class, values[1]), attributeName);
            }
            if (Short.class.isAssignableFrom(targetClass)) {
                return this.deserializeRange(targetClass, this.deserializeValue(Short.class, values[0]), this.deserializeValue(Short.class, values[1]), attributeName);
            }
            if (Integer.class.isAssignableFrom(targetClass)) {
                return this.deserializeRange(targetClass, this.deserializeValue(Integer.class, values[0]), this.deserializeValue(Integer.class, values[1]), attributeName);
            }
            if (Long.class.isAssignableFrom(targetClass)) {
                return this.deserializeRange(targetClass, this.deserializeValue(Long.class, values[0]), this.deserializeValue(Long.class, values[1]), attributeName);
            }
            throw new RestInternalError("Deserialization of range JavaType: " + targetClass.getSimpleName() + " is not implemented yet. Attribute: " + attributeName);
        }
        throw new RestInternalError("Array of two values is required for range data type. Attribute: " + attributeName);
    }

    @Nonnull
    private <T extends Serializable> T deserializeRange(@Nonnull Class<T> targetClass, @Nullable Object from, @Nullable Object to, @Nonnull String attributeName) {
        if (from != null && to != null) {
            if (OffsetDateTime.class.isAssignableFrom(targetClass)) {
                return (T)DateTimeRange.between((OffsetDateTime)((OffsetDateTime)from), (OffsetDateTime)((OffsetDateTime)to));
            }
            if (BigDecimal.class.isAssignableFrom(targetClass)) {
                return (T)BigDecimalNumberRange.between((BigDecimal)((BigDecimal)from), (BigDecimal)((BigDecimal)to));
            }
            if (Byte.class.isAssignableFrom(targetClass)) {
                return (T)ByteNumberRange.between((Byte)((Byte)from), (Byte)((Byte)to));
            }
            if (Short.class.isAssignableFrom(targetClass)) {
                return (T)ShortNumberRange.between((Short)((Short)from), (Short)((Short)to));
            }
            if (Integer.class.isAssignableFrom(targetClass)) {
                return (T)IntegerNumberRange.between((Integer)((Integer)from), (Integer)((Integer)to));
            }
            if (Long.class.isAssignableFrom(targetClass)) {
                return (T)LongNumberRange.between((Long)((Long)from), (Long)((Long)to));
            }
            throw new RestInternalError("Deserialization of range JavaType: " + targetClass.getSimpleName() + " is not implemented yet. Attribute: " + attributeName);
        }
        if (from != null) {
            if (OffsetDateTime.class.isAssignableFrom(targetClass)) {
                return (T)DateTimeRange.since((OffsetDateTime)((OffsetDateTime)from));
            }
            if (BigDecimal.class.isAssignableFrom(targetClass)) {
                return (T)BigDecimalNumberRange.from((BigDecimal)((BigDecimal)from));
            }
            if (Byte.class.isAssignableFrom(targetClass)) {
                return (T)ByteNumberRange.from((Byte)((Byte)from));
            }
            if (Short.class.isAssignableFrom(targetClass)) {
                return (T)ShortNumberRange.from((Short)((Short)from));
            }
            if (Integer.class.isAssignableFrom(targetClass)) {
                return (T)IntegerNumberRange.from((Integer)((Integer)from));
            }
            if (Long.class.isAssignableFrom(targetClass)) {
                return (T)LongNumberRange.from((Long)((Long)from));
            }
            throw new RestInternalError("Deserialization of range JavaType: " + targetClass.getSimpleName() + " is not implemented yet. Attribute: " + attributeName);
        }
        if (to != null) {
            if (OffsetDateTime.class.isAssignableFrom(targetClass)) {
                return (T)DateTimeRange.until((OffsetDateTime)((OffsetDateTime)to));
            }
            if (BigDecimal.class.isAssignableFrom(targetClass)) {
                return (T)BigDecimalNumberRange.to((BigDecimal)((BigDecimal)to));
            }
            if (Byte.class.isAssignableFrom(targetClass)) {
                return (T)ByteNumberRange.to((Byte)((Byte)to));
            }
            if (Short.class.isAssignableFrom(targetClass)) {
                return (T)ShortNumberRange.to((Short)((Short)to));
            }
            if (Integer.class.isAssignableFrom(targetClass)) {
                return (T)IntegerNumberRange.to((Integer)((Integer)to));
            }
            if (Long.class.isAssignableFrom(targetClass)) {
                return (T)LongNumberRange.to((Long)((Long)to));
            }
            throw new RestInternalError("Deserialization of range JavaType: " + targetClass.getSimpleName() + " is not implemented yet. Attribute: " + attributeName);
        }
        throw new RestInternalError("Both values for range data type are null which is not allowed. Attribute: " + attributeName);
    }

    @Nullable
    private Byte deserializeByteNumber(@Nonnull JsonNode value) {
        return this.deserializeByteNumber(value.asText());
    }

    @Nullable
    private Byte deserializeByteNumber(@Nonnull String value) {
        byte[] decoded = Base64.getDecoder().decode(value);
        if (decoded.length == 1) {
            return decoded[0];
        }
        if (decoded.length == 0) {
            return null;
        }
        throw new RestQueryResolvingInternalError("Byte value must be always single byte not array of bytes.");
    }

    @Nonnull
    private <T extends Serializable, E extends Enum<E>> T deserializeEnum(@Nonnull Class<T> targetClass, @Nonnull JsonNode value) {
        return Enum.valueOf(targetClass, value.asText());
    }

    @Nonnull
    private <T extends Serializable, E extends Enum<E>> T deserializeEnum(@Nonnull Class<T> targetClass, @Nonnull String value) {
        return Enum.valueOf(targetClass, value);
    }

    @Nonnull
    private Class<? extends Serializable> resolveDataClass(@Nonnull Schema schema) {
        if ("string".equals(schema.getType())) {
            if (schema.getFormat() == null) {
                if (schema.getEnum() != null) {
                    Class<? extends Enum<?>> enumTemplate = this.enumMapping.get(schema.getName());
                    Assert.isPremiseValid((enumTemplate != null ? 1 : 0) != 0, () -> new RestInternalError("No Java enum for enum `" + schema.getName() + "` found."));
                    return enumTemplate;
                }
                return String.class;
            }
            return switch (schema.getFormat()) {
                case "date" -> LocalDate.class;
                case "date-time" -> OffsetDateTime.class;
                case "local-time" -> LocalTime.class;
                case "local-date-time" -> LocalDateTime.class;
                case "iso-4217" -> Currency.class;
                case "uuid" -> UUID.class;
                case "locale" -> Locale.class;
                case "char" -> Character.class;
                case "decimal" -> BigDecimal.class;
                case "int64" -> Long.class;
                default -> throw new RestInternalError("Unknown schema format " + schema.getFormat() + " for String type.");
            };
        }
        if ("integer".equals(schema.getType())) {
            if (schema.getFormat().equals("int32")) {
                return Integer.class;
            }
            if (schema.getFormat().equals("int16")) {
                return Short.class;
            }
            if (schema.getFormat().equals("int8")) {
                return Byte.class;
            }
            throw new RestInternalError("Unknown schema format " + schema.getFormat() + " for Integer type.");
        }
        if ("boolean".equals(schema.getType())) {
            return Boolean.class;
        }
        throw new RestInternalError("Unknown schema type " + schema.getType());
    }

    @Nonnull
    private String[] getNodeValuesAsStringArray(@Nonnull JsonNode jsonNode, @Nonnull String attributeName) {
        if (jsonNode instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)jsonNode;
            String[] strings = new String[arrayNode.size()];
            for (int i = 0; i < arrayNode.size(); ++i) {
                strings[i] = arrayNode.get(i).asText();
            }
            return strings;
        }
        throw new RestInvalidArgumentException("Can't get array of string if JsonNode is not instance of ArrayNode. Class: " + jsonNode.getClass().getSimpleName(), "Expecting array but getting single value. Attribute name: " + attributeName);
    }

    public DataDeserializer(OpenAPI openApi, Map<String, Class<? extends Enum<?>>> enumMapping) {
        this.openApi = openApi;
        this.enumMapping = enumMapping;
    }
}

