/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.resolver.serializer;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.evitadb.api.requestResponse.data.PriceContract;
import io.evitadb.dataType.ComplexDataObject;
import io.evitadb.dataType.EvitaDataTypes;
import io.evitadb.dataType.Predecessor;
import io.evitadb.dataType.Range;
import io.evitadb.dataType.data.ComplexDataObjectToJsonConverter;
import io.evitadb.dataType.data.DataItemVisitor;
import io.evitadb.externalApi.api.catalog.dataApi.model.PriceDescriptor;
import io.evitadb.externalApi.rest.exception.RestInternalError;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Currency;
import java.util.Locale;
import java.util.UUID;
import javax.annotation.Nonnull;

public class ObjectJsonSerializer {
    private final ObjectMapper objectMapper;
    private final JsonNodeFactory jsonNodeFactory;

    public ObjectJsonSerializer(@Nonnull ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.jsonNodeFactory = new JsonNodeFactory(true);
    }

    public ObjectNode objectNode() {
        return this.jsonNodeFactory.objectNode();
    }

    public ArrayNode arrayNode() {
        return this.jsonNodeFactory.arrayNode();
    }

    @Nonnull
    public JsonNode serializeObject(@Nonnull Object value) {
        if (value instanceof Collection) {
            Collection values = (Collection)value;
            return this.serializeCollection(values);
        }
        if (value instanceof Object[]) {
            Object[] values = (Object[])value;
            return this.serializeArray(values);
        }
        if (value.getClass().isArray()) {
            return this.serializeArray(value);
        }
        if (value instanceof String) {
            String string = (String)value;
            return this.jsonNodeFactory.textNode(string);
        }
        if (value instanceof Character) {
            Character character = (Character)value;
            return this.jsonNodeFactory.textNode(this.serialize(character));
        }
        if (value instanceof Integer) {
            Integer integer = (Integer)value;
            return this.jsonNodeFactory.numberNode(integer);
        }
        if (value instanceof Short) {
            Short shortNumber = (Short)value;
            return this.jsonNodeFactory.numberNode(shortNumber);
        }
        if (value instanceof Long) {
            Long longNumber = (Long)value;
            return this.jsonNodeFactory.textNode(this.serialize(longNumber));
        }
        if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            return this.jsonNodeFactory.booleanNode(bool.booleanValue());
        }
        if (value instanceof Byte) {
            Byte byteVal = (Byte)value;
            return this.jsonNodeFactory.numberNode(byteVal);
        }
        if (value instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)value;
            return this.jsonNodeFactory.textNode(this.serialize(bigDecimal));
        }
        if (value instanceof Locale) {
            Locale locale = (Locale)value;
            return this.jsonNodeFactory.textNode(this.serialize(locale));
        }
        if (value instanceof Currency) {
            Currency currency = (Currency)value;
            return this.jsonNodeFactory.textNode(this.serialize(currency));
        }
        if (value instanceof OffsetDateTime) {
            OffsetDateTime offsetDateTime = (OffsetDateTime)value;
            return this.jsonNodeFactory.textNode(this.serialize(offsetDateTime));
        }
        if (value instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)value;
            return this.jsonNodeFactory.textNode(this.serialize(localDateTime));
        }
        if (value instanceof LocalDate) {
            LocalDate dateTime = (LocalDate)value;
            return this.jsonNodeFactory.textNode(this.serialize(dateTime));
        }
        if (value instanceof LocalTime) {
            LocalTime localTime = (LocalTime)value;
            return this.jsonNodeFactory.textNode(this.serialize(localTime));
        }
        if (value instanceof ComplexDataObject) {
            ComplexDataObject complexDataObject = (ComplexDataObject)value;
            return this.serialize(complexDataObject);
        }
        if (value instanceof Range) {
            Range range = (Range)value;
            return this.serialize(range);
        }
        if (value instanceof UUID) {
            UUID uuid = (UUID)value;
            return this.jsonNodeFactory.textNode(ObjectJsonSerializer.serialize(uuid));
        }
        if (value instanceof Predecessor) {
            Predecessor predecessor = (Predecessor)value;
            return this.jsonNodeFactory.numberNode(this.serialize(predecessor));
        }
        if (value instanceof PriceContract) {
            PriceContract price = (PriceContract)value;
            return this.serialize(price);
        }
        if (value.getClass().isEnum()) {
            return this.jsonNodeFactory.textNode(this.serialize((Enum)value));
        }
        throw new RestInternalError("Serialization of value of class: " + value.getClass().getName() + " is not implemented yet.");
    }

    public JsonNode serializeCollection(@Nonnull Collection<?> values) {
        ArrayNode arrayNode = new ArrayNode(this.jsonNodeFactory, values.size());
        for (Object value : values) {
            arrayNode.add(this.serializeObject(value));
        }
        return arrayNode;
    }

    public JsonNode serializeArray(@Nonnull Object[] values) {
        ArrayNode arrayNode = new ArrayNode(this.jsonNodeFactory, values.length);
        for (Object value : values) {
            arrayNode.add(this.serializeObject(value));
        }
        return arrayNode;
    }

    public JsonNode serializeArray(@Nonnull Object values) {
        ArrayNode arrayNode = this.jsonNodeFactory.arrayNode();
        int arraySize = Array.getLength(values);
        for (int i = 0; i < arraySize; ++i) {
            Object item = Array.get(values, 0);
            arrayNode.add(this.serializeObject(item));
        }
        return arrayNode;
    }

    @Nonnull
    private String serialize(@Nonnull Long longNumber) {
        return String.valueOf(longNumber);
    }

    @Nonnull
    private String serialize(@Nonnull Character character) {
        return character.toString();
    }

    @Nonnull
    private String serialize(@Nonnull BigDecimal bigDecimal) {
        return EvitaDataTypes.formatValue((Serializable)bigDecimal);
    }

    @Nonnull
    private String serialize(@Nonnull Locale locale) {
        return locale.toLanguageTag();
    }

    @Nonnull
    private String serialize(@Nonnull Currency currency) {
        return currency.getCurrencyCode();
    }

    @Nonnull
    private String serialize(@Nonnull OffsetDateTime offsetDateTime) {
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(offsetDateTime.truncatedTo(ChronoUnit.MILLIS));
    }

    @Nonnull
    private String serialize(@Nonnull LocalDateTime localDateTime) {
        return DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(localDateTime.truncatedTo(ChronoUnit.MILLIS));
    }

    @Nonnull
    private String serialize(@Nonnull LocalDate localDate) {
        return DateTimeFormatter.ISO_LOCAL_DATE.format(localDate);
    }

    @Nonnull
    private String serialize(@Nonnull LocalTime localTime) {
        return DateTimeFormatter.ISO_LOCAL_TIME.format(localTime.truncatedTo(ChronoUnit.MILLIS));
    }

    @Nonnull
    private String serialize(@Nonnull Enum<?> e) {
        return e.name();
    }

    @Nonnull
    private static String serialize(@Nonnull UUID uuid) {
        return uuid.toString();
    }

    private JsonNode serialize(@Nonnull ComplexDataObject complexDataObject) {
        ComplexDataObjectToJsonConverter converter = new ComplexDataObjectToJsonConverter(this.objectMapper);
        complexDataObject.accept((DataItemVisitor)converter);
        return converter.getRootNode();
    }

    private JsonNode serialize(@Nonnull Range<?> range) {
        ArrayNode rangeNode = this.jsonNodeFactory.arrayNode(2);
        rangeNode.add((JsonNode)(range.getPreciseFrom() != null ? this.serializeObject(range.getPreciseFrom()) : this.jsonNodeFactory.nullNode()));
        rangeNode.add((JsonNode)(range.getPreciseTo() != null ? this.serializeObject(range.getPreciseTo()) : this.jsonNodeFactory.nullNode()));
        return rangeNode;
    }

    private int serialize(@Nonnull Predecessor predecessor) {
        return predecessor.predecessorId();
    }

    private JsonNode serialize(@Nonnull PriceContract price) {
        ObjectNode priceNode = this.jsonNodeFactory.objectNode();
        priceNode.putIfAbsent(PriceDescriptor.PRICE_ID.name(), this.serializeObject(price.priceId()));
        priceNode.putIfAbsent(PriceDescriptor.PRICE_LIST.name(), this.serializeObject(price.priceList()));
        priceNode.putIfAbsent(PriceDescriptor.CURRENCY.name(), this.serializeObject(price.currency()));
        priceNode.putIfAbsent(PriceDescriptor.INNER_RECORD_ID.name(), price.innerRecordId() != null ? this.serializeObject(price.innerRecordId()) : null);
        priceNode.putIfAbsent(PriceDescriptor.SELLABLE.name(), this.serializeObject(price.sellable()));
        priceNode.putIfAbsent(PriceDescriptor.PRICE_WITHOUT_TAX.name(), this.serializeObject(price.priceWithoutTax()));
        priceNode.putIfAbsent(PriceDescriptor.PRICE_WITH_TAX.name(), this.serializeObject(price.priceWithTax()));
        priceNode.putIfAbsent(PriceDescriptor.TAX_RATE.name(), this.serializeObject(price.taxRate()));
        priceNode.putIfAbsent(PriceDescriptor.VALIDITY.name(), price.validity() != null ? this.serializeObject(price.validity()) : null);
        return priceNode;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }
}

