/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.system.builder;

import io.evitadb.externalApi.api.model.PropertyDescriptorTransformer;
import io.evitadb.externalApi.api.system.model.CatalogDescriptor;
import io.evitadb.externalApi.api.system.model.CatalogUnionDescriptor;
import io.evitadb.externalApi.rest.api.dataType.DataTypesConverter;
import io.evitadb.externalApi.rest.api.model.PropertyDescriptorToOpenApiOperationPathParameterTransformer;
import io.evitadb.externalApi.rest.api.model.RestRootDescriptor;
import io.evitadb.externalApi.rest.api.openApi.OpenApiArray;
import io.evitadb.externalApi.rest.api.openApi.OpenApiEndpointParameter;
import io.evitadb.externalApi.rest.api.openApi.OpenApiNonNull;
import io.evitadb.externalApi.rest.api.openApi.OpenApiSystemEndpoint;
import io.evitadb.externalApi.rest.api.openApi.OpenApiTypeReference;
import io.evitadb.externalApi.rest.api.resolver.endpoint.OpenApiSpecificationHandler;
import io.evitadb.externalApi.rest.api.system.model.CatalogsHeaderDescriptor;
import io.evitadb.externalApi.rest.api.system.model.CreateCatalogRequestDescriptor;
import io.evitadb.externalApi.rest.api.system.model.LivenessDescriptor;
import io.evitadb.externalApi.rest.api.system.model.SystemRootDescriptor;
import io.evitadb.externalApi.rest.api.system.model.UpdateCatalogRequestDescriptor;
import io.evitadb.externalApi.rest.api.system.resolver.endpoint.CreateCatalogHandler;
import io.evitadb.externalApi.rest.api.system.resolver.endpoint.DeleteCatalogHandler;
import io.evitadb.externalApi.rest.api.system.resolver.endpoint.GetCatalogHandler;
import io.evitadb.externalApi.rest.api.system.resolver.endpoint.ListCatalogsHandler;
import io.evitadb.externalApi.rest.api.system.resolver.endpoint.LivenessHandler;
import io.evitadb.externalApi.rest.api.system.resolver.endpoint.UpdateCatalogHandler;
import io.swagger.v3.oas.models.PathItem;
import javax.annotation.Nonnull;

public class SystemEndpointBuilder {
    @Nonnull
    private final PropertyDescriptorToOpenApiOperationPathParameterTransformer operationPathParameterBuilderTransformer;

    @Nonnull
    public OpenApiSystemEndpoint buildOpenApiSpecificationEndpoint() {
        return OpenApiSystemEndpoint.newSystemEndpoint().path(p -> p.staticItem(RestRootDescriptor.OPEN_API_SPECIFICATION.urlPathItem())).method(PathItem.HttpMethod.GET).operationId(RestRootDescriptor.OPEN_API_SPECIFICATION.operation()).description(RestRootDescriptor.OPEN_API_SPECIFICATION.description()).successResponse(OpenApiNonNull.nonNull(DataTypesConverter.getOpenApiScalar(String.class))).handler(OpenApiSpecificationHandler::new).build();
    }

    @Nonnull
    public OpenApiSystemEndpoint buildLivenessEndpoint() {
        return OpenApiSystemEndpoint.newSystemEndpoint().path(p -> p.staticItem(SystemRootDescriptor.LIVENESS.urlPathItem())).method(PathItem.HttpMethod.GET).operationId(SystemRootDescriptor.LIVENESS.operation()).description(SystemRootDescriptor.LIVENESS.description()).successResponse(OpenApiNonNull.nonNull(OpenApiTypeReference.typeRefTo(LivenessDescriptor.THIS.name()))).handler(LivenessHandler::new).build();
    }

    @Nonnull
    public OpenApiSystemEndpoint buildGetCatalogEndpoint() {
        return OpenApiSystemEndpoint.newSystemEndpoint().path(p -> p.staticItem(SystemRootDescriptor.GET_CATALOG.urlPathItem()).paramItem((OpenApiEndpointParameter.Builder)CatalogsHeaderDescriptor.NAME.to((PropertyDescriptorTransformer)this.operationPathParameterBuilderTransformer))).method(PathItem.HttpMethod.GET).operationId(SystemRootDescriptor.GET_CATALOG.operation()).description(SystemRootDescriptor.GET_CATALOG.description()).successResponse(OpenApiTypeReference.typeRefTo(CatalogUnionDescriptor.THIS.name())).handler(GetCatalogHandler::new).build();
    }

    @Nonnull
    public OpenApiSystemEndpoint buildListCatalogsEndpoint() {
        return OpenApiSystemEndpoint.newSystemEndpoint().path(p -> p.staticItem(SystemRootDescriptor.LIST_CATALOGS.urlPathItem())).method(PathItem.HttpMethod.GET).operationId(SystemRootDescriptor.LIST_CATALOGS.operation()).description(SystemRootDescriptor.LIST_CATALOGS.description()).successResponse(OpenApiNonNull.nonNull(OpenApiArray.arrayOf(OpenApiTypeReference.typeRefTo(CatalogUnionDescriptor.THIS.name())))).handler(ListCatalogsHandler::new).build();
    }

    @Nonnull
    public OpenApiSystemEndpoint buildCreateCatalogEndpoint() {
        return OpenApiSystemEndpoint.newSystemEndpoint().path(p -> p.staticItem(SystemRootDescriptor.CREATE_CATALOG.urlPathItem())).method(PathItem.HttpMethod.POST).operationId(SystemRootDescriptor.CREATE_CATALOG.operation()).description(SystemRootDescriptor.CREATE_CATALOG.description()).requestBody(OpenApiTypeReference.typeRefTo(CreateCatalogRequestDescriptor.THIS.name())).successResponse(OpenApiNonNull.nonNull(OpenApiTypeReference.typeRefTo(CatalogDescriptor.THIS.name()))).handler(CreateCatalogHandler::new).build();
    }

    @Nonnull
    public OpenApiSystemEndpoint buildUpdateCatalogEndpoint() {
        return OpenApiSystemEndpoint.newSystemEndpoint().path(p -> p.staticItem(SystemRootDescriptor.UPDATE_CATALOG.urlPathItem()).paramItem((OpenApiEndpointParameter.Builder)CatalogsHeaderDescriptor.NAME.to((PropertyDescriptorTransformer)this.operationPathParameterBuilderTransformer))).method(PathItem.HttpMethod.PATCH).operationId(SystemRootDescriptor.UPDATE_CATALOG.operation()).description(SystemRootDescriptor.UPDATE_CATALOG.description()).requestBody(OpenApiTypeReference.typeRefTo(UpdateCatalogRequestDescriptor.THIS.name())).successResponse(OpenApiNonNull.nonNull(OpenApiTypeReference.typeRefTo(CatalogDescriptor.THIS.name()))).handler(UpdateCatalogHandler::new).build();
    }

    @Nonnull
    public OpenApiSystemEndpoint buildDeleteCatalogEndpoint() {
        return OpenApiSystemEndpoint.newSystemEndpoint().path(p -> p.staticItem(SystemRootDescriptor.DELETE_CATALOG.urlPathItem()).paramItem((OpenApiEndpointParameter.Builder)CatalogsHeaderDescriptor.NAME.to((PropertyDescriptorTransformer)this.operationPathParameterBuilderTransformer))).method(PathItem.HttpMethod.DELETE).operationId(SystemRootDescriptor.DELETE_CATALOG.operation()).description(SystemRootDescriptor.DELETE_CATALOG.description()).handler(DeleteCatalogHandler::new).build();
    }

    public SystemEndpointBuilder(@Nonnull PropertyDescriptorToOpenApiOperationPathParameterTransformer operationPathParameterBuilderTransformer) {
        if (operationPathParameterBuilderTransformer == null) {
            throw new NullPointerException("operationPathParameterBuilderTransformer is marked non-null but is null");
        }
        this.operationPathParameterBuilderTransformer = operationPathParameterBuilderTransformer;
    }
}

