/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.system.resolver.endpoint;

import io.evitadb.api.CatalogContract;
import io.evitadb.externalApi.rest.api.system.resolver.endpoint.SystemRestHandlingContext;
import io.evitadb.externalApi.rest.api.system.resolver.serializer.CatalogJsonSerializer;
import io.evitadb.externalApi.rest.exception.RestInternalError;
import io.evitadb.externalApi.rest.io.JsonRestHandler;
import io.evitadb.externalApi.rest.io.RestEndpointExchange;
import io.evitadb.utils.Assert;
import java.util.LinkedHashSet;
import javax.annotation.Nonnull;

public abstract class CatalogHandler
extends JsonRestHandler<SystemRestHandlingContext> {
    @Nonnull
    private final CatalogJsonSerializer catalogJsonSerializer;

    public CatalogHandler(@Nonnull SystemRestHandlingContext restApiHandlingContext) {
        super(restApiHandlingContext);
        this.catalogJsonSerializer = new CatalogJsonSerializer(restApiHandlingContext);
    }

    @Nonnull
    public LinkedHashSet<String> getSupportedResponseContentTypes() {
        return DEFAULT_SUPPORTED_CONTENT_TYPES;
    }

    @Override
    @Nonnull
    protected Object convertResultIntoSerializableObject(@Nonnull RestEndpointExchange exchange, @Nonnull Object catalog) {
        Assert.isPremiseValid((boolean)(catalog instanceof CatalogContract), () -> new RestInternalError("Catalog should be instance of CatalogContract, but was `" + catalog.getClass().getName() + "`."));
        return this.catalogJsonSerializer.serialize((CatalogContract)catalog);
    }
}

