/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.system.resolver.endpoint;

import io.evitadb.api.CatalogContract;
import io.evitadb.externalApi.http.EndpointResponse;
import io.evitadb.externalApi.http.NotFoundEndpointResponse;
import io.evitadb.externalApi.http.SuccessEndpointResponse;
import io.evitadb.externalApi.rest.api.system.model.CatalogsHeaderDescriptor;
import io.evitadb.externalApi.rest.api.system.resolver.endpoint.SystemRestHandlingContext;
import io.evitadb.externalApi.rest.exception.RestInternalError;
import io.evitadb.externalApi.rest.io.JsonRestHandler;
import io.evitadb.externalApi.rest.io.RestEndpointExchange;
import io.evitadb.utils.Assert;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;

public class DeleteCatalogHandler
extends JsonRestHandler<SystemRestHandlingContext> {
    public DeleteCatalogHandler(@Nonnull SystemRestHandlingContext restApiHandlingContext) {
        super(restApiHandlingContext);
    }

    @Override
    protected boolean modifiesData() {
        return true;
    }

    @Nonnull
    protected EndpointResponse doHandleRequest(@Nonnull RestEndpointExchange exchange) {
        Map<String, Object> parameters = this.getParametersFromRequest(exchange);
        String catalogName = (String)parameters.get(CatalogsHeaderDescriptor.NAME.name());
        Optional catalog = ((SystemRestHandlingContext)this.restHandlingContext).getEvita().getCatalogInstance(catalogName);
        if (catalog.isEmpty()) {
            return new NotFoundEndpointResponse();
        }
        boolean deleted = ((SystemRestHandlingContext)this.restHandlingContext).getEvita().deleteCatalogIfExists(((CatalogContract)catalog.get()).getName());
        Assert.isPremiseValid((boolean)deleted, () -> new RestInternalError("Could not delete catalog `" + ((CatalogContract)catalog.get()).getName() + "`, even though it should exist."));
        return new SuccessEndpointResponse();
    }

    @Nonnull
    public Set<String> getSupportedHttpMethods() {
        return Set.of("DELETE");
    }
}

