/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.system.resolver.endpoint;

import io.evitadb.externalApi.http.EndpointResponse;
import io.evitadb.externalApi.http.SuccessEndpointResponse;
import io.evitadb.externalApi.rest.api.system.resolver.endpoint.SystemRestHandlingContext;
import io.evitadb.externalApi.rest.api.system.resolver.serializer.CatalogJsonSerializer;
import io.evitadb.externalApi.rest.exception.RestInternalError;
import io.evitadb.externalApi.rest.io.JsonRestHandler;
import io.evitadb.externalApi.rest.io.RestEndpointExchange;
import io.evitadb.utils.Assert;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnull;

public class ListCatalogsHandler
extends JsonRestHandler<SystemRestHandlingContext> {
    @Nonnull
    private final CatalogJsonSerializer catalogJsonSerializer;

    public ListCatalogsHandler(@Nonnull SystemRestHandlingContext restApiHandlingContext) {
        super(restApiHandlingContext);
        this.catalogJsonSerializer = new CatalogJsonSerializer(restApiHandlingContext);
    }

    @Nonnull
    protected EndpointResponse doHandleRequest(@Nonnull RestEndpointExchange exchange) {
        Collection catalogs = ((SystemRestHandlingContext)this.restHandlingContext).getEvita().getCatalogs();
        return new SuccessEndpointResponse(this.convertResultIntoSerializableObject(exchange, catalogs));
    }

    @Nonnull
    public Set<String> getSupportedHttpMethods() {
        return Set.of("GET");
    }

    @Nonnull
    public LinkedHashSet<String> getSupportedResponseContentTypes() {
        return DEFAULT_SUPPORTED_CONTENT_TYPES;
    }

    @Override
    @Nonnull
    protected Object convertResultIntoSerializableObject(@Nonnull RestEndpointExchange exchange, @Nonnull Object catalogs) {
        Assert.isPremiseValid((boolean)(catalogs instanceof Collection), () -> new RestInternalError("Expected collection of catalogs, but got `" + catalogs.getClass().getName() + "`."));
        return this.catalogJsonSerializer.serialize((Collection)catalogs);
    }
}

