/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.system.resolver.endpoint;

import io.evitadb.api.CatalogContract;
import io.evitadb.api.CatalogState;
import io.evitadb.core.Evita;
import io.evitadb.externalApi.http.EndpointResponse;
import io.evitadb.externalApi.http.NotFoundEndpointResponse;
import io.evitadb.externalApi.http.SuccessEndpointResponse;
import io.evitadb.externalApi.rest.api.system.dto.UpdateCatalogRequestDto;
import io.evitadb.externalApi.rest.api.system.model.CatalogsHeaderDescriptor;
import io.evitadb.externalApi.rest.api.system.resolver.endpoint.CatalogHandler;
import io.evitadb.externalApi.rest.api.system.resolver.endpoint.SystemRestHandlingContext;
import io.evitadb.externalApi.rest.exception.RestInternalError;
import io.evitadb.externalApi.rest.exception.RestInvalidArgumentException;
import io.evitadb.externalApi.rest.io.RestEndpointExchange;
import io.evitadb.utils.Assert;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;

public class UpdateCatalogHandler
extends CatalogHandler {
    public UpdateCatalogHandler(@Nonnull SystemRestHandlingContext restApiHandlingContext) {
        super(restApiHandlingContext);
    }

    @Override
    protected boolean modifiesData() {
        return true;
    }

    @Nonnull
    protected EndpointResponse doHandleRequest(@Nonnull RestEndpointExchange exchange) {
        Map<String, Object> parameters = this.getParametersFromRequest(exchange);
        UpdateCatalogRequestDto requestBody = this.parseRequestBody(exchange, UpdateCatalogRequestDto.class);
        String catalogName = (String)parameters.get(CatalogsHeaderDescriptor.NAME.name());
        Optional catalog = ((SystemRestHandlingContext)this.restHandlingContext).getEvita().getCatalogInstance(catalogName);
        if (catalog.isEmpty()) {
            return new NotFoundEndpointResponse();
        }
        Optional<String> newCatalogName = this.renameCatalog((CatalogContract)catalog.get(), requestBody);
        this.switchCatalogToAliveState((CatalogContract)catalog.get(), requestBody);
        String nameOfUpdateCatalog = newCatalogName.orElse(catalogName);
        CatalogContract updatedCatalog = (CatalogContract)((SystemRestHandlingContext)this.restHandlingContext).getEvita().getCatalogInstance(nameOfUpdateCatalog).orElseThrow(() -> new RestInternalError("Couldn't find updated catalog `" + nameOfUpdateCatalog + "`"));
        return new SuccessEndpointResponse(this.convertResultIntoSerializableObject(exchange, updatedCatalog));
    }

    @Nonnull
    public Set<String> getSupportedHttpMethods() {
        return Set.of("PATCH");
    }

    @Nonnull
    public Set<String> getSupportedRequestContentTypes() {
        return DEFAULT_SUPPORTED_CONTENT_TYPES;
    }

    @Nonnull
    private Optional<String> renameCatalog(@Nonnull CatalogContract catalog, @Nonnull UpdateCatalogRequestDto requestBody) {
        Evita evita = ((SystemRestHandlingContext)this.restHandlingContext).getEvita();
        Optional<String> newCatalogName = Optional.ofNullable(requestBody.name());
        if (newCatalogName.isEmpty()) {
            return Optional.empty();
        }
        boolean overwriteTarget = Optional.ofNullable(requestBody.overwriteTarget()).orElse(false);
        if (overwriteTarget) {
            evita.replaceCatalog(catalog.getName(), newCatalogName.get());
        } else {
            evita.renameCatalog(catalog.getName(), newCatalogName.get());
        }
        return newCatalogName;
    }

    private void switchCatalogToAliveState(@Nonnull CatalogContract catalog, @Nonnull UpdateCatalogRequestDto requestBody) {
        Optional<CatalogState> newCatalogState = Optional.ofNullable(requestBody.catalogState());
        if (newCatalogState.isEmpty()) {
            return;
        }
        Assert.isTrue((newCatalogState.get() == CatalogState.ALIVE ? 1 : 0) != 0, () -> new RestInvalidArgumentException("A catalog can be switched only to the `ALIVE` state."));
        Assert.isTrue((catalog.getCatalogState() == CatalogState.WARMING_UP ? 1 : 0) != 0, () -> new RestInvalidArgumentException("Only a catalog in the `WARMING_UP` state can be switched to the `ALIVE` state."));
        boolean switched = catalog.goLive();
        Assert.isTrue((boolean)switched, () -> new RestInvalidArgumentException("A catalog couldn't be switched to the `ALIVE` state."));
    }
}

