/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.system.resolver.serializer;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.evitadb.api.CatalogContract;
import io.evitadb.core.Catalog;
import io.evitadb.core.CorruptedCatalog;
import io.evitadb.externalApi.api.catalog.schemaApi.model.NameVariantsDescriptor;
import io.evitadb.externalApi.api.system.model.CatalogDescriptor;
import io.evitadb.externalApi.api.system.model.CorruptedCatalogDescriptor;
import io.evitadb.externalApi.rest.api.resolver.serializer.ObjectJsonSerializer;
import io.evitadb.externalApi.rest.exception.RestInternalError;
import io.evitadb.externalApi.rest.io.RestHandlingContext;
import io.evitadb.utils.NamingConvention;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogJsonSerializer {
    private static final Logger log = LoggerFactory.getLogger(CatalogJsonSerializer.class);
    private final ObjectJsonSerializer objectJsonSerializer;

    public CatalogJsonSerializer(@Nonnull RestHandlingContext restHandlingContext) {
        this.objectJsonSerializer = new ObjectJsonSerializer(restHandlingContext.getObjectMapper());
    }

    @Nonnull
    public ObjectNode serialize(@Nonnull CatalogContract c) {
        if (c instanceof CorruptedCatalog) {
            CorruptedCatalog corruptedCatalog = (CorruptedCatalog)c;
            return this.serialize(corruptedCatalog);
        }
        if (c instanceof Catalog) {
            Catalog catalog = (Catalog)c;
            return this.serialize(catalog);
        }
        throw new RestInternalError("Missing support for serializing `" + c.getClass().getName() + "`.");
    }

    @Nonnull
    public ArrayNode serialize(@Nonnull Collection<CatalogContract> catalogs) {
        ArrayNode arrayNode = this.objectJsonSerializer.arrayNode();
        catalogs.forEach(catalog -> arrayNode.add((JsonNode)this.serialize((CatalogContract)catalog)));
        return arrayNode;
    }

    @Nonnull
    private ObjectNode serialize(@Nonnull Catalog catalog) {
        ObjectNode rootNode = this.objectJsonSerializer.objectNode();
        rootNode.put(CatalogDescriptor.NAME.name(), catalog.getName());
        rootNode.put(CatalogDescriptor.NAME_VARIANTS.name(), (JsonNode)this.serializeNameVariants(catalog.getSchema().getNameVariants()));
        rootNode.put(CatalogDescriptor.VERSION.name(), String.valueOf(catalog.getVersion()));
        rootNode.put(CatalogDescriptor.CATALOG_STATE.name(), catalog.getCatalogState().name());
        rootNode.put(CatalogDescriptor.SUPPORTS_TRANSACTION.name(), catalog.supportsTransaction());
        rootNode.put(CatalogDescriptor.CORRUPTED.name(), false);
        ArrayNode entityTypes = this.objectJsonSerializer.arrayNode();
        catalog.getEntityTypes().forEach(arg_0 -> ((ArrayNode)entityTypes).add(arg_0));
        rootNode.set(CatalogDescriptor.ENTITY_TYPES.name(), (JsonNode)entityTypes);
        return rootNode;
    }

    @Nonnull
    private ObjectNode serialize(@Nonnull CorruptedCatalog corruptedCatalog) {
        ObjectNode rootNode = this.objectJsonSerializer.objectNode();
        rootNode.put(CorruptedCatalogDescriptor.NAME.name(), corruptedCatalog.getName());
        rootNode.put(CorruptedCatalogDescriptor.CATALOG_STORAGE_PATH.name(), corruptedCatalog.getCatalogStoragePath().toString());
        rootNode.put(CorruptedCatalogDescriptor.CAUSE.name(), corruptedCatalog.getCause().toString());
        rootNode.put(CorruptedCatalogDescriptor.CORRUPTED.name(), true);
        return rootNode;
    }

    @Nonnull
    private ObjectNode serializeNameVariants(@Nonnull Map<NamingConvention, String> nameVariants) {
        ObjectNode nameVariantsNode = this.objectJsonSerializer.objectNode();
        nameVariantsNode.put(NameVariantsDescriptor.CAMEL_CASE.name(), nameVariants.get(NamingConvention.CAMEL_CASE));
        nameVariantsNode.put(NameVariantsDescriptor.PASCAL_CASE.name(), nameVariants.get(NamingConvention.PASCAL_CASE));
        nameVariantsNode.put(NameVariantsDescriptor.SNAKE_CASE.name(), nameVariants.get(NamingConvention.SNAKE_CASE));
        nameVariantsNode.put(NameVariantsDescriptor.UPPER_SNAKE_CASE.name(), nameVariants.get(NamingConvention.UPPER_SNAKE_CASE));
        nameVariantsNode.put(NameVariantsDescriptor.KEBAB_CASE.name(), nameVariants.get(NamingConvention.KEBAB_CASE));
        return nameVariantsNode;
    }
}

