/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.configuration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.evitadb.externalApi.configuration.AbstractApiConfiguration;
import io.evitadb.externalApi.configuration.ApiWithOriginControl;
import io.evitadb.externalApi.configuration.ApiWithSpecificPrefix;
import io.evitadb.utils.Assert;
import java.util.Arrays;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RestConfig
extends AbstractApiConfiguration
implements ApiWithSpecificPrefix,
ApiWithOriginControl {
    private static final String BASE_REST_PATH = "rest";
    private static final Pattern ORIGIN_PATTERN = Pattern.compile("([a-z]+)://([\\w.]+)(:(\\d+))?");
    private final String prefix;
    private final String[] allowedOrigins;

    public RestConfig() {
        this.prefix = BASE_REST_PATH;
        this.allowedOrigins = null;
    }

    public RestConfig(@Nonnull String host) {
        super(Boolean.valueOf(true), host);
        this.prefix = BASE_REST_PATH;
        this.allowedOrigins = null;
    }

    @JsonCreator
    public RestConfig(@Nullable @JsonProperty(value="enabled") Boolean enabled, @Nonnull @JsonProperty(value="host") String host, @Nullable @JsonProperty(value="exposedHost") String exposedHost, @Nullable @JsonProperty(value="tlsEnabled") Boolean tlsEnabled, @Nullable @JsonProperty(value="prefix") String prefix, @Nullable @JsonProperty(value="allowedOrigins") String allowedOrigins) {
        super(enabled, host, exposedHost, tlsEnabled);
        this.prefix = Optional.ofNullable(prefix).orElse(BASE_REST_PATH);
        this.allowedOrigins = allowedOrigins == null ? null : (String[])Arrays.stream(allowedOrigins.split(",")).peek(origin -> {
            Matcher matcher = ORIGIN_PATTERN.matcher((CharSequence)origin);
            Assert.isTrue((boolean)matcher.matches(), (String)("Invalid origin definition: " + origin));
        }).toArray(String[]::new);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String[] getAllowedOrigins() {
        return this.allowedOrigins;
    }
}

