/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.io;

import io.evitadb.externalApi.configuration.ApiWithOriginControl;
import io.evitadb.externalApi.http.CorsPreflightHandler;
import io.evitadb.externalApi.rest.io.RestEndpointHandler;
import io.evitadb.utils.CollectionUtils;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.BlockingHandler;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CorsEndpoint {
    @Nullable
    private final Set<String> allowedOrigins;
    @Nonnull
    private final Set<String> allowedMethods = CollectionUtils.createHashSet((int)10);
    @Nonnull
    private final Set<String> allowedHeaders = CollectionUtils.createHashSet((int)2);

    public CorsEndpoint(@Nonnull ApiWithOriginControl restConfig) {
        this.allowedOrigins = restConfig.getAllowedOrigins() == null ? null : Set.of(restConfig.getAllowedOrigins());
        this.allowedHeaders.add("traceparent");
        this.allowedHeaders.add("X-EvitaDB-ClientID");
    }

    public void addMetadataFromHandler(@Nonnull RestEndpointHandler<?> handler) {
        this.addMetadata(handler.getSupportedHttpMethods(), !handler.getSupportedRequestContentTypes().isEmpty(), !handler.getSupportedResponseContentTypes().isEmpty());
    }

    public void addMetadata(@Nonnull Set<String> supportedHttpMethods, boolean supportsRequestContentType, boolean supportsResponseContentType) {
        this.allowedMethods.addAll(supportedHttpMethods);
        if (supportsRequestContentType) {
            this.allowedHeaders.add("Content-Type");
        }
        if (supportsResponseContentType) {
            this.allowedHeaders.add("Accept");
        }
    }

    @Nonnull
    public HttpHandler toHandler() {
        return new BlockingHandler((HttpHandler)new CorsPreflightHandler(this.allowedOrigins, this.allowedMethods, this.allowedHeaders));
    }
}

