/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.io;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.evitadb.externalApi.rest.exception.OpenApiInternalError;
import io.evitadb.externalApi.rest.exception.RestInternalError;
import io.evitadb.externalApi.rest.exception.RestInvalidArgumentException;
import io.evitadb.externalApi.rest.io.RestEndpointExchange;
import io.evitadb.externalApi.rest.io.RestEndpointHandler;
import io.evitadb.externalApi.rest.io.RestHandlingContext;
import io.evitadb.utils.Assert;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nonnull;

public abstract class JsonRestHandler<CTX extends RestHandlingContext>
extends RestEndpointHandler<CTX> {
    protected static final LinkedHashSet<String> DEFAULT_SUPPORTED_CONTENT_TYPES = new LinkedHashSet<String>(List.of("application/json"));

    protected JsonRestHandler(@Nonnull CTX restApiHandlingContext) {
        super(restApiHandlingContext);
    }

    @Nonnull
    protected <T> T parseRequestBody(@Nonnull RestEndpointExchange exchange, @Nonnull Class<T> dataClass) {
        String content = this.readRawRequestBody(exchange);
        Assert.isTrue((!content.trim().isEmpty() ? 1 : 0) != 0, () -> new RestInvalidArgumentException("Request's body contains no data."));
        try {
            return (T)this.restHandlingContext.getObjectMapper().readValue(content, dataClass);
        }
        catch (JsonProcessingException e) {
            throw new RestInternalError("Could not parse request body: ", e);
        }
    }

    protected void writeResult(@Nonnull RestEndpointExchange exchange, @Nonnull OutputStream outputStream, @Nonnull Object result) {
        try {
            this.restHandlingContext.getObjectMapper().writeValue(outputStream, result);
        }
        catch (IOException e) {
            throw new OpenApiInternalError("Could not serialize Java object response to JSON: " + e.getMessage(), "Could not provide response data.", e);
        }
    }

    @Nonnull
    protected Object convertResultIntoSerializableObject(@Nonnull RestEndpointExchange exchange, @Nonnull Object result) {
        return result;
    }
}

