/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.io;

import io.evitadb.api.EvitaSessionContract;
import io.evitadb.externalApi.http.EndpointExchange;
import io.evitadb.externalApi.rest.exception.RestInternalError;
import io.evitadb.utils.Assert;
import io.undertow.server.HttpServerExchange;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RestEndpointExchange
implements EndpointExchange {
    @Nonnull
    private final HttpServerExchange serverExchange;
    @Nullable
    private EvitaSessionContract session;
    @Nonnull
    private final String httpMethod;
    @Nullable
    private final String requestBodyContentType;
    @Nullable
    private final String preferredResponseContentType;

    @Nonnull
    public HttpServerExchange serverExchange() {
        return this.serverExchange;
    }

    @Nonnull
    public EvitaSessionContract session() {
        Assert.isPremiseValid((this.session != null ? 1 : 0) != 0, () -> new RestInternalError("Session is not available for this exchange."));
        Assert.isPremiseValid((boolean)this.session.isActive(), () -> new RestInternalError("Session has been already closed. No one should access the session!"));
        return this.session;
    }

    public void session(@Nonnull EvitaSessionContract session) {
        Assert.isPremiseValid((this.session == null ? 1 : 0) != 0, () -> new RestInternalError("Session cannot overwritten when already set."));
        this.session = session;
    }

    public void closeSessionIfOpen() {
        if (this.session != null) {
            this.session.close();
        }
    }

    @Nonnull
    public String httpMethod() {
        return this.httpMethod;
    }

    @Nullable
    public String requestBodyContentType() {
        return this.requestBodyContentType;
    }

    @Nullable
    public String preferredResponseContentType() {
        return this.preferredResponseContentType;
    }

    public void close() {
        this.closeSessionIfOpen();
    }

    public RestEndpointExchange(@Nonnull HttpServerExchange serverExchange, @Nonnull String httpMethod, @Nullable String requestBodyContentType, @Nullable String preferredResponseContentType) {
        if (serverExchange == null) {
            throw new NullPointerException("serverExchange is marked non-null but is null");
        }
        if (httpMethod == null) {
            throw new NullPointerException("httpMethod is marked non-null but is null");
        }
        this.serverExchange = serverExchange;
        this.httpMethod = httpMethod;
        this.requestBodyContentType = requestBodyContentType;
        this.preferredResponseContentType = preferredResponseContentType;
    }
}

