/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.io;

import io.evitadb.api.EvitaSessionContract;
import io.evitadb.core.Evita;
import io.evitadb.externalApi.exception.ExternalApiInternalError;
import io.evitadb.externalApi.exception.ExternalApiInvalidUsageException;
import io.evitadb.externalApi.http.EndpointExchange;
import io.evitadb.externalApi.http.EndpointHandler;
import io.evitadb.externalApi.http.EndpointResponse;
import io.evitadb.externalApi.rest.api.catalog.resolver.endpoint.CatalogRestHandlingContext;
import io.evitadb.externalApi.rest.api.openApi.SchemaUtils;
import io.evitadb.externalApi.rest.api.resolver.serializer.DataDeserializer;
import io.evitadb.externalApi.rest.exception.RestInternalError;
import io.evitadb.externalApi.rest.exception.RestInvalidArgumentException;
import io.evitadb.externalApi.rest.exception.RestRequiredParameterMissingException;
import io.evitadb.externalApi.rest.io.RestEndpointExchange;
import io.evitadb.externalApi.rest.io.RestHandlingContext;
import io.evitadb.utils.CollectionUtils;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.undertow.server.HttpServerExchange;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RestEndpointHandler<CTX extends RestHandlingContext>
extends EndpointHandler<RestEndpointExchange> {
    private static final Logger log = LoggerFactory.getLogger(RestEndpointHandler.class);
    @Nonnull
    protected final CTX restHandlingContext;
    @Nonnull
    protected final DataDeserializer dataDeserializer;

    protected RestEndpointHandler(@Nonnull CTX restHandlingContext) {
        this.restHandlingContext = restHandlingContext;
        this.dataDeserializer = new DataDeserializer(((RestHandlingContext)this.restHandlingContext).getOpenApi(), ((RestHandlingContext)this.restHandlingContext).getEnumMapping());
    }

    public void handleRequest(HttpServerExchange serverExchange) {
        this.handleRequestWithTracingContext(serverExchange);
    }

    private void handleRequestWithTracingContext(@Nonnull HttpServerExchange serverExchange) {
        ((RestHandlingContext)this.restHandlingContext).getTracingContext().executeWithinBlock("REST", (Object)serverExchange, () -> super.handleRequest(serverExchange));
    }

    @Nonnull
    protected RestEndpointExchange createEndpointExchange(@Nonnull HttpServerExchange serverExchange, @Nonnull String httpMethod, @Nullable String requestBodyMediaType, @Nullable String preferredResponseMediaType) {
        return new RestEndpointExchange(serverExchange, httpMethod, requestBodyMediaType, preferredResponseMediaType);
    }

    protected void beforeRequestHandled(@Nonnull RestEndpointExchange exchange) {
        this.createSession(exchange).ifPresent(exchange::session);
    }

    protected void afterRequestHandled(@Nonnull RestEndpointExchange exchange, @Nonnull EndpointResponse response) {
        exchange.closeSessionIfOpen();
    }

    @Nullable
    protected Optional<EvitaSessionContract> createSession(@Nonnull RestEndpointExchange exchange) {
        CTX CTX = this.restHandlingContext;
        if (!(CTX instanceof CatalogRestHandlingContext)) {
            return Optional.empty();
        }
        CatalogRestHandlingContext catalogRestHandlingContext = (CatalogRestHandlingContext)CTX;
        Evita evita = ((RestHandlingContext)this.restHandlingContext).getEvita();
        String catalogName = catalogRestHandlingContext.getCatalogSchema().getName();
        if (this.modifiesData()) {
            return Optional.of(evita.createReadWriteSession(catalogName));
        }
        return Optional.of(evita.createReadOnlySession(catalogName));
    }

    protected boolean modifiesData() {
        return false;
    }

    @Nonnull
    protected <T extends ExternalApiInternalError> T createInternalError(@Nonnull String message) {
        return (T)((Object)new RestInternalError(message));
    }

    @Nonnull
    protected <T extends ExternalApiInternalError> T createInternalError(@Nonnull String message, @Nonnull Throwable cause) {
        return (T)((Object)new RestInternalError(message, cause));
    }

    @Nonnull
    protected <T extends ExternalApiInvalidUsageException> T createInvalidUsageException(@Nonnull String message) {
        return (T)((Object)new RestInvalidArgumentException(message));
    }

    @Nonnull
    protected Map<String, Object> getParametersFromRequest(@Nonnull EndpointExchange exchange) {
        HashMap<String, Deque<String>> parameters = new HashMap<String, Deque<String>>(exchange.serverExchange().getQueryParameters());
        Operation operation = ((RestHandlingContext)this.restHandlingContext).getEndpointOperation();
        HashMap parameterData = CollectionUtils.createHashMap((int)operation.getParameters().size());
        if (operation.getParameters() != null) {
            for (Parameter parameter : operation.getParameters()) {
                this.getParameterFromRequest(parameters, parameter).ifPresent(data -> {
                    parameterData.put(parameter.getName(), data);
                    parameters.remove(parameter.getName());
                });
            }
        }
        if (!parameters.isEmpty()) {
            throw new RestInvalidArgumentException("Following parameters are not supported in this particular request, please look into OpenAPI schema for more information. Parameters: " + String.join((CharSequence)", ", parameters.keySet()));
        }
        return parameterData;
    }

    @Nonnull
    private Optional<Object> getParameterFromRequest(@Nonnull Map<String, Deque<String>> queryParameters, @Nonnull Parameter parameter) {
        Deque<String> queryParam = queryParameters.get(parameter.getName());
        if (queryParam != null) {
            return Optional.ofNullable(this.dataDeserializer.deserializeValue(this.getParameterSchema(parameter), (String[])queryParam.toArray(String[]::new)));
        }
        if (Boolean.TRUE.equals(parameter.getRequired())) {
            throw new RestRequiredParameterMissingException("Required parameter " + parameter.getName() + " is missing in query data (" + parameter.getIn() + ")");
        }
        return Optional.empty();
    }

    @Nonnull
    protected Schema getParameterSchema(@Nonnull Parameter parameter) {
        return SchemaUtils.getTargetSchemaFromRefOrOneOf(parameter.getSchema(), ((RestHandlingContext)this.restHandlingContext).getOpenApi());
    }
}

