/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.io;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.evitadb.core.Evita;
import io.evitadb.externalApi.trace.ExternalApiTracingContextProvider;
import io.evitadb.externalApi.utils.ExternalApiTracingContext;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import java.util.Map;
import javax.annotation.Nonnull;

public class RestHandlingContext {
    @Nonnull
    protected final ObjectMapper objectMapper;
    @Nonnull
    protected final Evita evita;
    @Nonnull
    protected final ExternalApiTracingContext<Object> tracingContext;
    @Nonnull
    private final OpenAPI openApi;
    @Nonnull
    private final Map<String, Class<? extends Enum<?>>> enumMapping;
    @Nonnull
    private final Operation endpointOperation;
    private final boolean localized;

    public RestHandlingContext(@Nonnull ObjectMapper objectMapper, @Nonnull Evita evita, @Nonnull OpenAPI openApi, @Nonnull Map<String, Class<? extends Enum<?>>> enumMapping, @Nonnull Operation endpointOperation, boolean localized) {
        this.objectMapper = objectMapper;
        this.evita = evita;
        this.tracingContext = ExternalApiTracingContextProvider.getContext();
        this.openApi = openApi;
        this.enumMapping = enumMapping;
        this.endpointOperation = endpointOperation;
        this.localized = localized;
    }

    @Nonnull
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Nonnull
    public Evita getEvita() {
        return this.evita;
    }

    @Nonnull
    public ExternalApiTracingContext<Object> getTracingContext() {
        return this.tracingContext;
    }

    @Nonnull
    public OpenAPI getOpenApi() {
        return this.openApi;
    }

    @Nonnull
    public Map<String, Class<? extends Enum<?>>> getEnumMapping() {
        return this.enumMapping;
    }

    @Nonnull
    public Operation getEndpointOperation() {
        return this.endpointOperation;
    }

    public boolean isLocalized() {
        return this.localized;
    }
}

