/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.store.compressor;

import io.evitadb.store.exception.CompressionKeyUnknownException;
import io.evitadb.store.service.KeyCompressor;
import io.evitadb.utils.Assert;
import io.evitadb.utils.CollectionUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ReadOnlyKeyCompressor
implements KeyCompressor {
    private static final long serialVersionUID = 2737776892039254889L;
    private final Map<Integer, Object> idToKeyIndex;
    private final Map<Object, Integer> keyToIdIndex;

    public ReadOnlyKeyCompressor(Map<Integer, Object> keys) {
        int peek = 0;
        HashMap idToKeyIndexInstance = CollectionUtils.createHashMap((int)keys.size());
        HashMap keyToIdIndexInstance = CollectionUtils.createHashMap((int)keys.size());
        for (Map.Entry<Integer, Object> entry : keys.entrySet()) {
            idToKeyIndexInstance.put(entry.getKey(), entry.getValue());
            keyToIdIndexInstance.put(entry.getValue(), entry.getKey());
            if (entry.getKey() <= peek) continue;
            peek = entry.getKey();
        }
        this.idToKeyIndex = Collections.unmodifiableMap(idToKeyIndexInstance);
        this.keyToIdIndex = Collections.unmodifiableMap(keyToIdIndexInstance);
    }

    @Override
    @Nonnull
    public Map<Integer, Object> getKeys() {
        return this.idToKeyIndex;
    }

    @Override
    public <T extends Comparable<T>> int getId(@Nonnull T key) {
        Integer id = this.keyToIdIndex.get(key);
        Assert.isPremiseValid((id != null ? 1 : 0) != 0, () -> new CompressionKeyUnknownException("There is no id for key " + key + "!"));
        return id;
    }

    @Override
    @Nullable
    public <T extends Comparable<T>> Integer getIdIfExists(@Nonnull T key) {
        return this.keyToIdIndex.get(key);
    }

    @Override
    @Nonnull
    public <T extends Comparable<T>> T getKeyForId(int id) {
        Object key = this.idToKeyIndex.get(id);
        Assert.notNull((Object)key, (String)("There is no key for id " + id + "!"));
        return (T)((Comparable)key);
    }

    public Map<Integer, Object> getIdToKeyIndex() {
        return this.idToKeyIndex;
    }
}

