/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.store.compressor;

import io.evitadb.store.service.KeyCompressor;
import io.evitadb.utils.Assert;
import io.evitadb.utils.CollectionUtils;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ReadWriteKeyCompressor
implements KeyCompressor {
    private static final long serialVersionUID = -791089303429347949L;
    private final Map<Integer, Object> idToKeyIndex;
    private final Map<Object, Integer> keyToIdIndex;
    private final AtomicInteger sequence;
    private final AtomicBoolean dirty = new AtomicBoolean();

    public ReadWriteKeyCompressor(Map<Integer, Object> keys) {
        int peek = 0;
        this.idToKeyIndex = CollectionUtils.createHashMap((int)keys.size());
        this.keyToIdIndex = CollectionUtils.createHashMap((int)keys.size());
        for (Map.Entry<Integer, Object> entry : keys.entrySet()) {
            this.idToKeyIndex.put(entry.getKey(), entry.getValue());
            this.keyToIdIndex.put(entry.getValue(), entry.getKey());
            if (entry.getKey() <= peek) continue;
            peek = entry.getKey();
        }
        this.sequence = new AtomicInteger(peek);
    }

    public boolean resetDirtyFlag() {
        return this.dirty.getAndSet(false);
    }

    @Override
    @Nonnull
    public Map<Integer, Object> getKeys() {
        return this.idToKeyIndex;
    }

    @Override
    public <T extends Comparable<T>> int getId(@Nonnull T key) {
        return this.keyToIdIndex.computeIfAbsent(key, o -> {
            int id = this.sequence.incrementAndGet();
            this.idToKeyIndex.put(id, o);
            this.dirty.compareAndSet(false, true);
            return id;
        });
    }

    @Override
    @Nullable
    public <T extends Comparable<T>> Integer getIdIfExists(@Nonnull T key) {
        return this.keyToIdIndex.get(key);
    }

    @Override
    @Nonnull
    public <T extends Comparable<T>> T getKeyForId(int id) {
        Object key = this.idToKeyIndex.get(id);
        Assert.notNull((Object)key, (String)("There is no key for id " + id + "!"));
        return (T)((Comparable)key);
    }

    public Map<Integer, Object> getIdToKeyIndex() {
        return this.idToKeyIndex;
    }
}

