/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.store.dataType.exception;

import io.evitadb.store.exception.SerializationException;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class StoredVersionNotSupportedException
extends SerializationException {
    private static final long serialVersionUID = -6363067960456231518L;
    private final Class<?> serializedClass;
    private final long encounteredVersion;
    private final Set<Long> currentlySupportedVersions;

    public StoredVersionNotSupportedException(@Nonnull Class<?> serializedClass, long encounteredVersion, @Nonnull Set<Long> currentlySupportedVersions) {
        super("Cannot deserialize class " + serializedClass.getName() + " with serial version UID " + encounteredVersion + ". Supported backward compatible versions for this class are: " + (currentlySupportedVersions.isEmpty() ? "none" : currentlySupportedVersions.stream().map(Object::toString).collect(Collectors.joining(", "))));
        this.serializedClass = serializedClass;
        this.encounteredVersion = encounteredVersion;
        this.currentlySupportedVersions = currentlySupportedVersions;
    }

    public Class<?> getSerializedClass() {
        return this.serializedClass;
    }

    public long getEncounteredVersion() {
        return this.encounteredVersion;
    }

    public Set<Long> getCurrentlySupportedVersions() {
        return this.currentlySupportedVersions;
    }
}

