/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.store.dataType.serializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import io.evitadb.dataType.BigDecimalNumberRange;
import java.math.BigDecimal;

public class BigDecimalNumberRangeSerializer
extends Serializer<BigDecimalNumberRange> {
    public void write(Kryo kryo, Output output, BigDecimalNumberRange numberRange) {
        kryo.writeObject(output, (Object)numberRange.getPreciseFrom());
        kryo.writeObject(output, (Object)numberRange.getPreciseTo());
        kryo.writeObjectOrNull(output, (Object)numberRange.getRetainedDecimalPlaces(), Integer.class);
        output.writeLong(numberRange.getFrom());
        output.writeLong(numberRange.getTo());
    }

    public BigDecimalNumberRange read(Kryo kryo, Input input, Class<? extends BigDecimalNumberRange> type) {
        BigDecimal preciseFrom = (BigDecimal)kryo.readObject(input, BigDecimal.class);
        BigDecimal preciseTo = (BigDecimal)kryo.readObject(input, BigDecimal.class);
        Integer retainedDecimalPlaces = (Integer)kryo.readObjectOrNull(input, Integer.class);
        long from = input.readLong();
        long to = input.readLong();
        return BigDecimalNumberRange._internalBuild((BigDecimal)preciseFrom, (BigDecimal)preciseTo, (Integer)retainedDecimalPlaces, (long)from, (long)to);
    }
}

