/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.store.dataType.serializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import io.evitadb.dataType.DateTimeRange;
import io.evitadb.exception.EvitaInternalError;
import io.evitadb.store.dataType.serializer.OffsetDateTimeSerializer;
import java.time.OffsetDateTime;

public class DateTimeRangeSerializer
extends Serializer<DateTimeRange> {
    public void write(Kryo kryo, Output output, DateTimeRange dateTimeRange) {
        OffsetDateTime from = dateTimeRange.getPreciseFrom();
        if (from == null) {
            output.writeBoolean(false);
        } else {
            output.writeBoolean(true);
            OffsetDateTimeSerializer.write(output, from);
        }
        OffsetDateTime to = dateTimeRange.getPreciseTo();
        if (to == null) {
            output.writeBoolean(false);
        } else {
            output.writeBoolean(true);
            OffsetDateTimeSerializer.write(output, to);
        }
    }

    public DateTimeRange read(Kryo kryo, Input input, Class<? extends DateTimeRange> type) {
        OffsetDateTime to;
        OffsetDateTime from = input.readBoolean() ? OffsetDateTimeSerializer.read(input) : null;
        OffsetDateTime offsetDateTime = to = input.readBoolean() ? OffsetDateTimeSerializer.read(input) : null;
        if (from != null && to != null) {
            return DateTimeRange.between((OffsetDateTime)from, (OffsetDateTime)to);
        }
        if (from != null) {
            return DateTimeRange.since((OffsetDateTime)from);
        }
        if (to != null) {
            return DateTimeRange.until((OffsetDateTime)to);
        }
        throw new EvitaInternalError("The range have both bounds null. It should have not been created in the first place!");
    }
}

