/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.store.dataType.serializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import io.evitadb.dataType.EvitaDataTypes;
import io.evitadb.dataType.exception.UnsupportedDataTypeException;
import io.evitadb.store.dataType.serializer.EnumNameSerializer;

public class DefaultSerializer<T>
extends Serializer<T> {
    private final EnumNameSerializer enumNameSerializer = new EnumNameSerializer();

    public void write(Kryo kryo, Output output, T object) {
        Class<?> type = object.getClass();
        if (!type.isEnum()) {
            throw new UnsupportedDataTypeException(type, EvitaDataTypes.getSupportedDataTypes());
        }
        kryo.register(type, new EnumNameSerializer());
        kryo.writeObject(output, object, new EnumNameSerializer());
    }

    public T read(Kryo kryo, Input input, Class<? extends T> type) {
        if (type.isEnum()) {
            return (T)this.enumNameSerializer.read(kryo, input, type);
        }
        throw new UnsupportedDataTypeException(type, EvitaDataTypes.getSupportedDataTypes());
    }
}

