/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.store.dataType.serializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.lang.reflect.Array;

public class EnumArrayNameSerializer<T extends Enum<T>>
extends Serializer<T[]> {
    public void write(Kryo kryo, Output output, T[] object) {
        kryo.writeClass(output, object.getClass().getComponentType());
        output.writeVarInt(object.length, true);
        for (T item : object) {
            output.writeString(((Enum)item).name());
        }
    }

    public T[] read(Kryo kryo, Input input, Class<? extends T[]> type) {
        Class enumType = kryo.readClass(input).getType();
        int length = input.readVarInt(true);
        Enum[] result = (Enum[])Array.newInstance(enumType, length);
        for (int i = 0; i < length; ++i) {
            result[i] = Enum.valueOf(enumType, input.readString());
        }
        return result;
    }
}

