/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.store.dataType.serializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.Registration;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.EnumSet;

public class EnumSetSerializer
extends Serializer<EnumSet<?>> {
    public void write(Kryo kryo, Output output, EnumSet<?> object) {
        Serializer serializer;
        if (object.isEmpty()) {
            EnumSet<?> tmp = EnumSet.complementOf(object);
            if (tmp.isEmpty()) {
                throw new KryoException("An EnumSet must have a defined Enum to be serialized.");
            }
            serializer = kryo.writeClass(output, ((Enum)tmp.iterator().next()).getClass()).getSerializer();
        } else {
            serializer = kryo.writeClass(output, ((Enum)object.iterator().next()).getClass()).getSerializer();
        }
        output.writeVarInt(object.size(), true);
        for (Object element : object) {
            serializer.write(kryo, output, element);
        }
    }

    public EnumSet<?> read(Kryo kryo, Input input, Class<? extends EnumSet<?>> type) {
        Registration registration = kryo.readClass(input);
        EnumSet<Object> object = EnumSet.noneOf(registration.getType());
        Serializer serializer = registration.getSerializer();
        int length = input.readVarInt(true);
        for (int i = 0; i < length; ++i) {
            object.add(serializer.read(kryo, input, registration.getType()));
        }
        return object;
    }
}

