/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.store.dataType.serializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.Serializable;
import java.lang.reflect.Array;

public class GenericArraySerializer<T extends Serializable>
extends Serializer<T[]> {
    private final Class<T> targetType;

    public void write(Kryo kryo, Output output, T[] object) {
        output.writeVarInt(object.length, true);
        for (T serializable : object) {
            kryo.writeObjectOrNull(output, serializable, this.targetType);
        }
    }

    public T[] read(Kryo kryo, Input input, Class<? extends T[]> type) {
        int arrayLength = input.readVarInt(true);
        Serializable[] serializables = (Serializable[])Array.newInstance(this.targetType, arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            serializables[i] = (Serializable)kryo.readObjectOrNull(input, this.targetType);
        }
        return serializables;
    }

    public GenericArraySerializer(Class<T> targetType) {
        this.targetType = targetType;
    }
}

