/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.store.dataType.serializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.Map;
import java.util.function.IntFunction;

public class HeterogeneousMapSerializer<K, V>
extends Serializer<Map<K, V>> {
    public final IntFunction<Map<K, V>> setFactory;

    public void write(Kryo kryo, Output output, Map<K, V> object) {
        output.writeVarInt(object.size(), true);
        for (Map.Entry<K, V> entry : object.entrySet()) {
            kryo.writeClassAndObject(output, entry.getKey());
            kryo.writeClassAndObject(output, entry.getValue());
        }
    }

    public Map<K, V> read(Kryo kryo, Input input, Class<? extends Map<K, V>> type) {
        int itemCount = input.readVarInt(true);
        Map<Object, Object> targetSet = this.setFactory.apply(itemCount);
        for (int i = 0; i < itemCount; ++i) {
            targetSet.put(kryo.readClassAndObject(input), kryo.readClassAndObject(input));
        }
        return targetSet;
    }

    public HeterogeneousMapSerializer(IntFunction<Map<K, V>> setFactory) {
        this.setFactory = setFactory;
    }
}

