/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.store.dataType.serializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.Serializable;
import java.util.List;
import java.util.function.IntFunction;

public class ListSerializer<K extends Serializable>
extends Serializer<List<K>> {
    public final IntFunction<List<K>> listFactory;

    public void write(Kryo kryo, Output output, List<K> object) {
        output.writeVarInt(object.size(), true);
        boolean classWritten = false;
        for (Serializable item : object) {
            if (!classWritten) {
                kryo.writeClass(output, item.getClass());
                classWritten = true;
            }
            kryo.writeObject(output, (Object)item);
        }
    }

    public List<K> read(Kryo kryo, Input input, Class<? extends List<K>> type) {
        int size = input.readVarInt(true);
        Class itemClass = null;
        List<K> collection = this.listFactory.apply(size);
        for (int i = 0; i < size; ++i) {
            if (itemClass == null) {
                itemClass = kryo.readClass(input).getType();
            }
            collection.add((Serializable)kryo.readObject(input, itemClass));
        }
        return collection;
    }

    public ListSerializer(IntFunction<List<K>> listFactory) {
        this.listFactory = listFactory;
    }
}

