/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.store.dataType.serializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.ImmutableSerializer;
import java.time.LocalDate;

public class LocalDateSerializer
extends ImmutableSerializer<LocalDate> {
    public void write(Kryo kryo, Output out, LocalDate date) {
        LocalDateSerializer.write(out, date);
    }

    static void write(Output out, LocalDate date) {
        out.writeInt(date.getYear(), true);
        out.writeByte(date.getMonthValue());
        out.writeByte(date.getDayOfMonth());
    }

    public LocalDate read(Kryo kryo, Input in, Class type) {
        return LocalDateSerializer.read(in);
    }

    static LocalDate read(Input in) {
        int year = in.readInt(true);
        byte month = in.readByte();
        byte dayOfMonth = in.readByte();
        return LocalDate.of(year, month, (int)dayOfMonth);
    }
}

