/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.store.dataType.serializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.ImmutableSerializer;
import java.time.LocalTime;

public class LocalTimeSerializer
extends ImmutableSerializer<LocalTime> {
    public void write(Kryo kryo, Output out, LocalTime time) {
        LocalTimeSerializer.write(out, time);
    }

    static void write(Output out, LocalTime time) {
        if (time.getNano() == 0) {
            if (time.getSecond() == 0) {
                if (time.getMinute() == 0) {
                    out.writeByte(~time.getHour());
                } else {
                    out.writeByte(time.getHour());
                    out.writeByte(~time.getMinute());
                }
            } else {
                out.writeByte(time.getHour());
                out.writeByte(time.getMinute());
                out.writeByte(~time.getSecond());
            }
        } else {
            out.writeByte(time.getHour());
            out.writeByte(time.getMinute());
            out.writeByte(time.getSecond());
            out.writeInt(time.getNano(), true);
        }
    }

    public LocalTime read(Kryo kryo, Input in, Class type) {
        return LocalTimeSerializer.read(in);
    }

    static LocalTime read(Input in) {
        int hour = in.readByte();
        int minute = 0;
        int second = 0;
        int nano = 0;
        if (hour < 0) {
            hour ^= 0xFFFFFFFF;
        } else {
            minute = in.readByte();
            if (minute < 0) {
                minute ^= 0xFFFFFFFF;
            } else {
                second = in.readByte();
                if (second < 0) {
                    second ^= 0xFFFFFFFF;
                } else {
                    nano = in.readInt(true);
                }
            }
        }
        return LocalTime.of(hour, minute, second, nano);
    }
}

